/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat;

import java.util.Collections;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.greycat.GreycatNode;

public class GreycatLightEdge
implements IGraphEdge {
    private GreycatNode start;
    private GreycatNode end;
    private String type;

    public static GreycatLightEdge create(String type, GreycatNode from, GreycatNode to) {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            GreycatNode.NodeReader rFrom = from.getNodeReader();
            try {
                try (GreycatNode.NodeReader rTo = to.getNodeReader();){
                    GreycatNode.addOutgoing(type, rFrom, rTo);
                    GreycatNode.addIncoming(type, rTo, rFrom);
                }
                if (rFrom != null) {
                    rFrom.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rFrom != null) {
                    rFrom.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return new GreycatLightEdge(from, to, type);
    }

    public GreycatLightEdge(GreycatNode start, GreycatNode end, String type) {
        this.start = start;
        this.end = end;
        this.type = type;
    }

    public Object getId() {
        throw new UnsupportedOperationException("Light edges do not have an identifier");
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getPropertyKeys() {
        return Collections.emptySet();
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value) {
        throw new UnsupportedOperationException("Light edges cannot set properties");
    }

    public IGraphNode getStartNode() {
        return this.start;
    }

    public IGraphNode getEndNode() {
        return this.end;
    }

    public void delete() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            GreycatNode.NodeReader rStart = this.start.getNodeReader();
            try {
                try (GreycatNode.NodeReader rEnd = this.end.getNodeReader();){
                    GreycatNode.removeOutgoing(this.type, rStart, rEnd);
                    GreycatNode.removeIncoming(this.type, rEnd, rStart);
                }
                if (rStart != null) {
                    rStart.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rStart != null) {
                    rStart.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void removeProperty(String name) {
        throw new UnsupportedOperationException("Light edges cannot set properties");
    }

    public String toString() {
        return "GreycatLightEdge [start=" + this.start + ", end=" + this.end + ", type=" + this.type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GreycatLightEdge other = (GreycatLightEdge)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

