/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes.predicates;

import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.TimeAwareNodeFirstOrderOperation;

public class VersionRangeOperation
extends TimeAwareNodeFirstOrderOperation {
    private final IRangeBasedNodeScoper nodeScoper;

    public VersionRangeOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier, IRangeBasedNodeScoper nodeScoper) {
        super(containerModelSupplier);
        this.nodeScoper = nodeScoper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object execute(Variable iterator, Expression expression, IEolContext context, Function<ITimeAwareGraphNode, Object> versionWrapper, ITimeAwareGraphNode taNode) throws EolInternalException {
        try {
            ITimeAwareGraphNode version;
            long latestInstant = taNode.getLatestInstant();
            List versions = taNode.getVersionsBetween(taNode.getTime(), latestInstant);
            FrameStack scope = context.getFrameStack();
            ListIterator itVersion = versions.listIterator(versions.size());
            while (true) {
                if (!itVersion.hasPrevious()) {
                    return null;
                }
                version = (ITimeAwareGraphNode)itVersion.previous();
                Object listItem = versionWrapper.apply(version);
                if (iterator.getType() != null && !iterator.getType().isKind(listItem)) continue;
                scope.enterLocal(FrameType.UNPROTECTED, (ModuleElement)expression, new Variable[0]);
                scope.put(Variable.createReadOnlyVariable((String)iterator.getName(), (Object)listItem));
                Object bodyResult = context.getExecutorFactory().execute((ModuleElement)expression, context);
                scope.leaveLocal((ModuleElement)expression);
                if (bodyResult instanceof Boolean && ((Boolean)bodyResult).booleanValue()) break;
            }
            ITimeAwareGraphNode scoped = this.nodeScoper.scope(taNode, version);
            if (scoped != null) return versionWrapper.apply(scoped);
            return null;
        }
        catch (Exception ex) {
            throw new EolInternalException((Throwable)ex, (ModuleElement)expression);
        }
    }

    public boolean isOverridable() {
        return false;
    }

    @FunctionalInterface
    public static interface IRangeBasedNodeScoper {
        public ITimeAwareGraphNode scope(ITimeAwareGraphNode var1, ITimeAwareGraphNode var2);
    }
}

