/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.runtime.CompositeGraphChangeListener;
import org.eclipse.hawk.graph.updater.DeletionUtils;
import org.eclipse.hawk.graph.updater.DirtyDerivedFeaturesListener;
import org.eclipse.hawk.graph.updater.GraphModelInserter;
import org.eclipse.hawk.graph.updater.TypeCache;
import org.eclipse.hawk.graph.updater.Utils;

public class GraphModelUpdater
implements IModelUpdater {
    public static final String FILEINDEX_REPO_SEPARATOR = "||||";
    public static final String PROXY_REFERENCE_PREFIX = "hawkProxyRef:";
    public static final boolean CARES_ABOUT_RESOURCES = true;
    public static final String PROXY_FILE_WILDCARD = "*";
    protected IModelIndexer indexer;
    protected IConsole console;
    private boolean isActive = false;
    protected Set<IGraphNode> toBeUpdated = new HashSet<IGraphNode>();

    public void run(IConsole c, IModelIndexer hawk) throws Exception {
        this.indexer = hawk;
        this.console = c;
    }

    public boolean updateStore(VcsCommitItem f, IHawkModelResource res) {
        long start = System.currentTimeMillis();
        boolean success = true;
        IGraphDatabase g = this.indexer.getGraph();
        DirtyDerivedFeaturesListener l = new DirtyDerivedFeaturesListener(g);
        if (!this.indexer.getDerivedAttributes().isEmpty()) {
            this.indexer.addGraphChangeListener((IGraphChangeListener)l);
        }
        boolean verbose = this.hasFewItems(f);
        try {
            try {
                if (res == null) {
                    if (!this.deleteAll(f)) {
                        this.console.printerrln("warning: failed to delete item: " + f + "\nafter its resource failed to be loaded");
                        success = false;
                    }
                } else if (!this.createInserter().run(res, f, verbose)) {
                    this.console.printerrln("warning: failed to update item: " + f + "\nmodel resource: " + res);
                    success = false;
                }
            }
            catch (Exception ex) {
                this.console.printerrln((Throwable)ex);
                success = false;
            }
            if (verbose) {
                long end = System.currentTimeMillis();
                this.console.println(String.valueOf((end - start) / 1000L) + "s" + (end - start) % 1000L + "ms [pure insertion]");
            }
        }
        finally {
            long s = System.currentTimeMillis();
            if (verbose) {
                this.console.print("marking any relevant derived attributes for update...");
                this.indexer.getCompositeStateListener().info("Marking relevant derived attributes for update...");
            }
            this.toBeUpdated.addAll(l.getNodesToBeUpdated());
            this.indexer.removeGraphChangeListener((IGraphChangeListener)l);
            if (verbose) {
                long end = System.currentTimeMillis();
                this.console.println(String.valueOf((end - s) / 1000L) + "s" + (end - s) % 1000L + "ms");
                this.indexer.getCompositeStateListener().info("Marked relevant derived attributes for update. " + (end - s) / 1000L + "s" + (end - s) % 1000L + "ms");
            }
        }
        return success;
    }

    private boolean hasFewItems(VcsCommitItem f) {
        return f.getCommit().getItems().size() < 100;
    }

    public void updateProxies() {
        long start = System.currentTimeMillis();
        this.console.println("attempting to resolve any leftover cross-file references...");
        try {
            this.indexer.getCompositeStateListener().info("Resolving any leftover cross-file references...");
            this.createInserter().resolveProxies(this.indexer.getGraph());
        }
        catch (Exception e) {
            this.console.printerrln("Exception in updateStore - resolving proxies, returning 0:");
            this.console.printerrln((Throwable)e);
        }
        this.console.println("attempting to resolve any uninitialized derived attributes...");
        try {
            this.indexer.getCompositeStateListener().info("Resolving any uninitialized derived attributes...");
            this.createInserter().resolveDerivedAttributeProxies(this.indexer.getDerivedAttributeExecutionEngine());
        }
        catch (Exception e) {
            this.console.printerrln("Exception in updateStore - resolving DERIVED proxies, returning 0:");
            this.console.printerrln((Throwable)e);
        }
        this.console.println("attempting to update any relevant derived attributes...");
        try {
            this.indexer.getCompositeStateListener().info("Updating any affected derived attributes...");
            this.createInserter().updateDerivedAttributes(this.indexer.getDerivedAttributeExecutionEngine(), this.toBeUpdated);
            this.toBeUpdated = new HashSet<IGraphNode>();
        }
        catch (Exception e) {
            this.toBeUpdated = new HashSet<IGraphNode>();
            this.console.printerrln("Exception in updateStore - UPDATING DERIVED attributes");
            this.console.printerrln((Throwable)e);
        }
        long end = System.currentTimeMillis();
        this.console.println(String.valueOf((end - start) / 1000L) + "s" + (end - start) % 1000L + "ms [proxy update]");
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void shutdown() {
    }

    public boolean caresAboutResources() {
        return true;
    }

    public boolean deleteAll(IVcsManager c) throws Exception {
        boolean ret = false;
        IGraphDatabase graph = this.indexer.getGraph();
        Throwable throwable = null;
        Object var5_6 = null;
        try (IGraphTransaction t = graph.beginTransaction();){
            IGraphNodeIndex filedictionary = graph.getFileIndex();
            IGraphIterable fileNodes = filedictionary.query("id", (Object)(String.valueOf(c.getLocation()) + PROXY_FILE_WILDCARD));
            VcsCommit fakeCommit = new VcsCommit();
            VcsRepositoryDelta delta = new VcsRepositoryDelta(Collections.singleton(fakeCommit));
            delta.setManager(c);
            fakeCommit.setAuthor("hawk");
            fakeCommit.setJavaDate(new Date());
            fakeCommit.setRevision(String.valueOf(c.getCurrentRevision()) + "-deleted");
            fakeCommit.setMessage("stopped indexing");
            CompositeGraphChangeListener changeListener = this.indexer.getCompositeGraphChangeListener();
            for (IGraphNode fileNode : fileNodes) {
                VcsCommitItem item = new VcsCommitItem();
                item.setChangeType(VcsChangeType.DELETED);
                item.setCommit(fakeCommit);
                String path = fileNode.getProperty("_hawkid").toString();
                item.setPath(path.startsWith("/") ? path : "/" + path);
                fakeCommit.getItems().add(item);
                this.createDeletionUtils().deleteAll(fileNode, item, (IGraphChangeListener)changeListener);
            }
            t.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ret;
    }

    public boolean deleteAll(VcsCommitItem c) throws Exception {
        this.indexer.getCompositeStateListener().info("Deleting all contents of file: " + c.getPath() + "...");
        boolean ret = false;
        IGraphNode n = new Utils().getFileNodeFromVCSCommitItem(this.indexer.getGraph(), c);
        if (n != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (IGraphTransaction t = this.indexer.getGraph().beginTransaction();){
                    ret = this.createDeletionUtils().deleteAll(n, c, (IGraphChangeListener)this.indexer.getCompositeGraphChangeListener());
                    t.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.console.printerrln((Throwable)e);
                ret = false;
            }
        } else {
            return true;
        }
        this.indexer.getCompositeStateListener().info("Deleted all contents of file: " + c.getPath() + ".");
        return ret;
    }

    public void updateDerivedAttribute(String metamodeluri, String typename, String attributename, String attributetype, boolean isMany, boolean isOrdered, boolean isUnique, String derivationlanguage, String derivationlogic) {
        this.createInserter().updateDerivedAttribute(metamodeluri, typename, attributename, attributetype, isMany, isOrdered, isUnique, derivationlanguage, derivationlogic);
    }

    public void updateIndexedAttribute(String metamodeluri, String typename, String attributename) {
        this.createInserter().updateIndexedAttribute(metamodeluri, typename, attributename);
    }

    public String getName() {
        return "Default Hawk Graph Model Updater (v1.0)";
    }

    public Set<VcsCommitItem> compareWithLocalFiles(Set<VcsCommitItem> reposItems) {
        if (reposItems.isEmpty()) {
            return reposItems;
        }
        VcsCommitItem firstItem = reposItems.iterator().next();
        String repositoryURL = firstItem.getCommit().getDelta().getManager().getLocation();
        HashSet<VcsCommitItem> changed = new HashSet<VcsCommitItem>();
        changed.addAll(reposItems);
        IGraphDatabase graph = this.indexer.getGraph();
        if (graph != null) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (IGraphTransaction tx = graph.beginTransaction();){
                    IGraphNodeIndex filedictionary = graph.getFileIndex();
                    if (filedictionary != null && filedictionary.query("id", (Object)(String.valueOf(repositoryURL) + FILEINDEX_REPO_SEPARATOR + PROXY_FILE_WILDCARD)).iterator().hasNext()) {
                        for (VcsCommitItem r : reposItems) {
                            String rev = "-2";
                            try {
                                IGraphIterable ret = filedictionary.get("id", (Object)(String.valueOf(repositoryURL) + FILEINDEX_REPO_SEPARATOR + r.getPath()));
                                if (ret.iterator().hasNext()) {
                                    IGraphNode n = (IGraphNode)ret.getSingle();
                                    rev = (String)n.getProperty("revision");
                                }
                            }
                            catch (Exception e) {
                                this.console.printerrln((Throwable)e);
                            }
                            if (!r.getCommit().getRevision().equals(rev)) continue;
                            changed.remove(r);
                        }
                    }
                    tx.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.console.printerrln((Throwable)e);
            }
        }
        return changed;
    }

    public GraphModelInserter createInserter() {
        return new GraphModelInserter(this.indexer, this::createDeletionUtils, new TypeCache(this.indexer));
    }

    protected DeletionUtils createDeletionUtils() {
        return new DeletionUtils(this.indexer.getGraph());
    }
}

