/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.patterns;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.patterns.IShortCircuitReducer;
import org.eclipse.hawk.timeaware.queries.operations.patterns.VersionQuantifierOperation;

public class BoundedVersionQuantifierOperation
extends AbstractOperation {
    private final Function<Integer, IShortCircuitReducer> reducerLambda;
    private final Supplier<TimeAwareEOLQueryEngine> modelSupplier;

    public BoundedVersionQuantifierOperation(Supplier<TimeAwareEOLQueryEngine> containerModel, Function<Integer, IShortCircuitReducer> reducerLambda) {
        this.modelSupplier = containerModel;
        this.reducerLambda = reducerLambda;
    }

    public Object execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        Object countResult;
        if (expressions.size() != 2) {
            throw new EolRuntimeException("Bounded version quantifiers require an element predicate lambda expression and a count expression");
        }
        Parameter iterator = iterators.get(0);
        EolType iteratorType = iterator.getType(context);
        if (target == EolNoType.Instance && iteratorType instanceof EolModelElementType) {
            target = ((EolModelElementType)iteratorType).getAllOfKind();
        }
        if (!((countResult = context.getExecutorFactory().execute((ModuleElement)expressions.get(1), context)) instanceof Number)) {
            throw new EolRuntimeException("Count expression should return a number");
        }
        int count = ((Number)countResult).intValue();
        return new VersionQuantifierOperation(this.modelSupplier, this.reducerLambda.apply(count)).execute(target, operationNameExpression, iterators, expressions, context);
    }
}

