/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.timeaware;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.sqlite.SQLiteEdge;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteDatabase;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareSQLiteEdge
implements IGraphEdge {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteEdge.class);
    protected final TimeAwareSQLiteDatabase db;
    private final int id;
    private final int from;
    private final int to;
    private final String type;
    private final long time;

    public TimeAwareSQLiteEdge(TimeAwareSQLiteDatabase db, int edgeId, int from, int to, String type, long time) {
        this.db = db;
        this.id = edgeId;
        this.type = type;
        this.from = from;
        this.to = to;
        this.time = time;
    }

    public Object getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getPropertyKeys() {
        try {
            PreparedStatement stmt = this.db.getQueries().getEdgePropKeysStatement(this.id, this.time);
            stmt.execute();
            return this.db.getConnection().getStrings(stmt);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Object getProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getQueries().getEdgePropValueStatement(this.id, name, this.time);
            stmt.execute();
            return this.db.getConnection().getPropertyValue(stmt);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        try {
            value = this.db.getConnection().preprocessPropertyValue(value);
            PreparedStatement stmt = this.db.getQueries().getUpsertEdgePropStatement(this.id, name, value, this.time);
            int rowCount = stmt.executeUpdate();
            assert (rowCount == 1) : "One row should have been inserted/updated when setting the property";
        }
        catch (IOException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public IGraphNode getStartNode() {
        return new TimeAwareSQLiteNode(this.db, this.from, this.time);
    }

    public IGraphNode getEndNode() {
        return new TimeAwareSQLiteNode(this.db, this.to, this.time);
    }

    public void delete() {
        try {
            this.db.getQueries().getDeleteEdgePropsStatement(this.id, this.time).executeUpdate();
            this.db.getQueries().getDeleteEdgeStatement(this.id, this.time).executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getQueries().getDeleteEdgePropStatement(this.id, name, this.time);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.time);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeAwareSQLiteEdge other = (TimeAwareSQLiteEdge)obj;
        return this.id == other.id && this.time == other.time;
    }

    public String toString() {
        return "TimeAwareSQLiteEdge [id=" + this.id + ", time=" + this.time + "]";
    }
}

