/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.thrift.TException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.util.DerivedAttributeParameters;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.servlet.config.ConfigFileParser;
import org.eclipse.hawk.service.servlet.config.HawkInstanceConfig;
import org.eclipse.hawk.service.servlet.config.MetamodelParameters;
import org.eclipse.hawk.service.servlet.config.RepositoryParameters;
import org.eclipse.osgi.service.datalocation.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawkServerConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HawkServerConfigurator.class);
    private List<HawkInstanceConfig> hawkInstanceConfigs;
    private Hawk.Iface iface;
    private HManager manager;
    private ConfigFileParser parser;
    private int numberOfConfiguredInstances = 0;

    public HawkServerConfigurator(Hawk.Iface iface) {
        this.iface = iface;
        this.hawkInstanceConfigs = new ArrayList<HawkInstanceConfig>();
        this.manager = HManager.getInstance();
        this.parser = new ConfigFileParser();
        this.numberOfConfiguredInstances = 0;
    }

    public int getNumberOfConfiguredInstances() {
        return this.numberOfConfiguredInstances;
    }

    public void loadHawkServerConfigurations() {
        this.numberOfConfiguredInstances = 0;
        int configCount = 0;
        for (File file : this.getHawkServerConfigurationFiles()) {
            LOGGER.info("Configuring hawk instances from {}", (Object)file.getName());
            HawkInstanceConfig config = this.parser.parse(file);
            if (config != null) {
                LOGGER.info("Configuring Hawk instance {}", (Object)config.getName());
                this.hawkInstanceConfigs.add(config);
                this.configureHawkInstance(config);
            }
            ++configCount;
            while (this.numberOfConfiguredInstances < configCount) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<File> getHawkServerConfigurationFiles() {
        try {
            File configurationFolder = null;
            Location configurationLocation = Platform.getConfigurationLocation();
            if (configurationLocation == null) {
                configurationFolder = new File("configuration");
            } else {
                URL configurationURL = configurationLocation.getURL();
                String path = FileLocator.toFileURL((URL)configurationURL).getPath();
                configurationFolder = new File(path);
            }
            LOGGER.info("Looking for configuration files in {}", (Object)configurationFolder.getAbsolutePath());
            FilenameFilter filter = this.getXmlFilenameFilter();
            if (configurationFolder.exists() && configurationFolder.isDirectory()) {
                return new ArrayList<File>(Arrays.asList(configurationFolder.listFiles(filter)));
            }
            configurationFolder.mkdir();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private FilenameFilter getXmlFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(".xml");
            }
        };
    }

    private void configureHawkInstance(final HawkInstanceConfig config) {
        HModel hawkInstance = this.manager.getHawkByName(config.getName());
        try {
            if (hawkInstance == null) {
                hawkInstance = this.createHawkInstance(config);
            }
            this.addMissingPlugins(hawkInstance, config);
            hawkInstance.configurePolling(0, 0);
            hawkInstance.start(this.manager);
            hawkInstance.getIndexer().waitFor(IStateListener.HawkState.RUNNING, 3000L);
            final HModel hModel = hawkInstance;
            hawkInstance.getHawk().getModelIndexer().scheduleTask((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        HawkServerConfigurator.this.addMetamodels(hModel, config);
                    }
                    catch (Exception e) {
                        LOGGER.error("Configuring Hawk instance: Exception when adding metamodels", (Throwable)e);
                    }
                    HawkServerConfigurator.this.addMissingRepositories(hModel, config);
                    try {
                        HawkServerConfigurator.this.addMissingDerivedAttributes(hModel, config);
                        HawkServerConfigurator.this.addMissingIndexedAttributes(hModel, config);
                    }
                    catch (Exception e) {
                        LOGGER.error("Configuring Hawk instance: Exception when adding derived/indexed attributes", (Throwable)e);
                    }
                    hModel.configurePolling(config.getDelayMin(), config.getDelayMax());
                    HawkServerConfigurator hawkServerConfigurator = HawkServerConfigurator.this;
                    hawkServerConfigurator.numberOfConfiguredInstances = hawkServerConfigurator.numberOfConfiguredInstances + 1;
                    return null;
                }
            }, 0L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HModel createHawkInstance(HawkInstanceConfig config) throws TException {
        this.iface.createInstance(config.getName(), config.getBackend(), 0, 0, config.getPlugins(), config.getFactory());
        HModel hawkInstance = this.manager.getHawkByName(config.getName());
        return hawkInstance;
    }

    private void addMissingDerivedAttributes(HModel hawkInstance, HawkInstanceConfig config) throws Exception {
        Collection existingDerivedAttributes = hawkInstance.getDerivedAttributes();
        List metamodels = hawkInstance.getRegisteredMetamodels();
        for (DerivedAttributeParameters params : config.getDerivedAttributes()) {
            if (existingDerivedAttributes.contains(params)) continue;
            if (metamodels.contains(params.getMetamodelUri())) {
                hawkInstance.addDerivedAttribute(params.getMetamodelUri(), params.getTypeName(), params.getAttributeName(), params.getAttributeType(), Boolean.valueOf(params.isMany()), Boolean.valueOf(params.isOrdered()), Boolean.valueOf(params.isUnique()), params.getDerivationLanguage(), params.getDerivationLogic());
                continue;
            }
            LOGGER.error("Metamodel {} is not registered!", (Object)params.getMetamodelUri());
        }
    }

    private void addMissingIndexedAttributes(HModel hawkInstance, HawkInstanceConfig config) throws Exception {
        List metamodels = hawkInstance.getRegisteredMetamodels();
        Collection existingIndexedAttributes = hawkInstance.getIndexedAttributes();
        for (IndexedAttributeParameters params : config.getIndexedAttributes()) {
            if (existingIndexedAttributes.contains(params)) continue;
            if (metamodels.contains(params.getMetamodelUri())) {
                hawkInstance.addIndexedAttribute(params.getMetamodelUri(), params.getTypeName(), params.getAttributeName());
                continue;
            }
            LOGGER.error("Metamodel {} is not registered!", (Object)params.getMetamodelUri());
        }
    }

    private void addMissingRepositories(HModel hawkInstance, HawkInstanceConfig config) {
        Collection existingLocations = hawkInstance.getLocations();
        for (RepositoryParameters params : config.getRepositories()) {
            if (existingLocations.contains(params.getLocation())) continue;
            hawkInstance.addVCS(params.getLocation(), params.getType(), params.getUser(), params.getPass(), params.isFrozen());
        }
    }

    private void addMetamodels(HModel hawkInstance, HawkInstanceConfig config) throws Exception {
        for (MetamodelParameters params : config.getMetamodels()) {
            if (params.getLocation() == null || params.getLocation().isEmpty()) continue;
            File file = new File(params.getLocation());
            hawkInstance.registerMeta(new File[]{file});
        }
    }

    private void addMissingPlugins(HModel hawkInstance, HawkInstanceConfig config) throws Exception {
        ArrayList<String> availablePlugins = new ArrayList<String>();
        for (IHawkPlugin hp : this.manager.getAvailablePlugins()) {
            switch (hp.getCategory()) {
                case METAMODEL_RESOURCE_FACTORY: 
                case MODEL_RESOURCE_FACTORY: 
                case MODEL_UPDATER: 
                case GRAPH_CHANGE_LISTENER: {
                    availablePlugins.add(hp.getType());
                    break;
                }
            }
        }
        List existingPlugins = hawkInstance.getEnabledPlugins();
        ArrayList<String> missingPlugins = new ArrayList<String>();
        for (String plugin : config.getPlugins()) {
            if (availablePlugins.contains(plugin)) {
                if (existingPlugins.contains(plugin)) continue;
                missingPlugins.add(plugin);
                continue;
            }
            LOGGER.error("Plugin {} is not available!", (Object)plugin);
        }
        if (!missingPlugins.isEmpty()) {
            hawkInstance.addPlugins(missingPlugins);
            this.manager.saveHawkToMetadata(hawkInstance, true);
        }
    }
}

