/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.glsp.server.types.ElementTypeHint;

public class EdgeTypeHint
extends ElementTypeHint {
    private boolean routable;
    private List<String> sourceElementTypeIds;
    private List<String> targetElementTypeIds;
    private boolean dynamic;

    public EdgeTypeHint() {
    }

    public EdgeTypeHint(String elementTypeId, boolean repositionable, boolean deletable, boolean routable, List<String> sourceElementTypeIds, List<String> targetElementTypeIds) {
        this(elementTypeId, repositionable, deletable, routable, false, sourceElementTypeIds, targetElementTypeIds);
    }

    public EdgeTypeHint(String elementTypeId, boolean repositionable, boolean deletable, boolean routable, boolean dynamic, List<String> sourceElementTypeIds, List<String> targetElementTypeIds) {
        super(elementTypeId, repositionable, deletable);
        this.routable = routable;
        this.sourceElementTypeIds = sourceElementTypeIds;
        this.targetElementTypeIds = targetElementTypeIds;
    }

    public boolean isRoutable() {
        return this.routable;
    }

    public void setRoutable(boolean routable) {
        this.routable = routable;
    }

    public Optional<List<String>> getSourceElementTypeIds() {
        return Optional.ofNullable(this.sourceElementTypeIds);
    }

    public void setSourceElementTypeIds(List<String> sourceElementTypeIds) {
        this.sourceElementTypeIds = sourceElementTypeIds;
    }

    public void addSourceElementTypeId(String ... elementTypeIds) {
        if (this.sourceElementTypeIds == null) {
            this.sourceElementTypeIds = new ArrayList<String>();
        }
        Stream.of(elementTypeIds).forEach(id -> {
            boolean bl = this.sourceElementTypeIds.add((String)id);
        });
    }

    public Optional<List<String>> getTargetElementTypeIds() {
        return Optional.ofNullable(this.targetElementTypeIds);
    }

    public void setTargetElementTypeIds(List<String> targetElementTypeIds) {
        this.targetElementTypeIds = targetElementTypeIds;
    }

    public void addTargetElementTypeId(String ... elementTypeIds) {
        if (this.targetElementTypeIds == null) {
            this.targetElementTypeIds = new ArrayList<String>();
        }
        Stream.of(elementTypeIds).forEach(id -> {
            boolean bl = this.targetElementTypeIds.add((String)id);
        });
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.dynamic = isDynamic;
    }
}

