/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.marker;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.example.workflow.wfgraph.ActivityNode;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GLabel;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.model.GModelState;

public class WorkflowModelValidator
implements ModelValidator {
    @Inject
    protected GModelState modelState;

    public List<Marker> doLiveValidation(GModelElement element) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        if (element instanceof ActivityNode) {
            ActivityNode activityNode = (ActivityNode)element;
            if ("decisionNode".equals(activityNode.getNodeType())) {
                markers.addAll(this.validateDecisionNode(element));
            } else if ("mergeNode".equals(activityNode.getNodeType())) {
                markers.addAll(this.validateMergeNode(element));
            }
        }
        return markers;
    }

    public List<Marker> doBatchValidation(GModelElement element) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        if (element instanceof TaskNode) {
            markers.addAll(this.validateTaskNode(element));
        }
        return markers;
    }

    private List<Marker> validateTaskNode(GModelElement taskNode) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        this.validateTaskNode_isAutomated(taskNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        this.validateTaskNode_labelStartsUpperCase(taskNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        return markers;
    }

    private Optional<Marker> validateTaskNode_isAutomated(GModelElement element) {
        TaskNode taskNode = (TaskNode)element;
        if ("automated".equals(taskNode.getTaskType())) {
            String id = element.getId();
            return Optional.of(new Marker("Automated task", "This is an automated task", id, "info"));
        }
        return Optional.empty();
    }

    private Optional<Marker> validateTaskNode_labelStartsUpperCase(GModelElement element) {
        TaskNode taskNode = (TaskNode)element;
        boolean hasLowerCaseLabel = taskNode.getChildren().stream().filter(c -> "label:heading".equals(c.getType())).filter(GLabel.class::isInstance).map(GLabel.class::cast).map(GLabel::getText).anyMatch(text -> text.length() > 0 && !Character.isUpperCase(text.charAt(0)));
        if (hasLowerCaseLabel) {
            return Optional.of(new Marker("Task node label in upper case", "Task node names should start with upper case letters", element.getId(), "warning"));
        }
        return Optional.empty();
    }

    private List<Marker> validateDecisionNode(GModelElement decisionNode) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        this.validateDecisionNode_hasOneIncomingEdge(decisionNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        return markers;
    }

    private Optional<Marker> validateDecisionNode_hasOneIncomingEdge(GModelElement decisionNode) {
        Collection incomingEdges = this.modelState.getIndex().getIncomingEdges(decisionNode);
        if (incomingEdges.size() > 1) {
            return Optional.of(new Marker("Too many incoming edges", "Decision node may only have one incoming edge.", decisionNode.getId(), "error"));
        }
        if (incomingEdges.size() == 0) {
            return Optional.of(new Marker("Missing incoming edge", "Decision node must have one incoming edge.", decisionNode.getId(), "error"));
        }
        return Optional.empty();
    }

    private List<Marker> validateMergeNode(GModelElement mergeNode) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        this.validateMergeNode_hasOneOutgoingEdge(mergeNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        return markers;
    }

    private Optional<Marker> validateMergeNode_hasOneOutgoingEdge(GModelElement mergeNode) {
        Collection outgoingEdges = this.modelState.getIndex().getOutgoingEdges(mergeNode);
        if (outgoingEdges.size() > 1) {
            return Optional.of(new Marker("Too many outgoing edges", "Merge node may only have one outgoing edge.", mergeNode.getId(), "error"));
        }
        if (outgoingEdges.size() == 0) {
            return Optional.of(new Marker("Missing outgoing edge", "Merge node must have one incoming edge.", mergeNode.getId(), "error"));
        }
        return Optional.empty();
    }
}

