/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.ui.util.JavaProjectUtilities;
import org.eclipse.jdt.internal.ui.util.ResourcesUtility;

public final class LoggedCreateTargetQueries
implements ICreateTargetQueries {
    private final CreateTargetExecutionLog fLog;

    public LoggedCreateTargetQueries(CreateTargetExecutionLog log) {
        Assert.isNotNull((Object)log);
        this.fLog = log;
    }

    @Override
    public ICreateTargetQuery createNewPackageQuery() {
        return new CreateTargetQuery();
    }

    public CreateTargetExecutionLog getCreateTargetExecutionLog() {
        return this.fLog;
    }

    private final class CreateTargetQuery
    implements ICreateTargetQuery {
        private CreateTargetQuery() {
        }

        private void createJavaProject(IProject project) throws CoreException {
            JavaProjectUtilities.createJavaProject(project);
        }

        private void createPackageFragmentRoot(IPackageFragmentRoot root) throws CoreException {
            JavaProjectUtilities.createPackageFragmentRoot(root);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getCreatedTarget(Object selection) {
            Object target = LoggedCreateTargetQueries.this.fLog.getCreatedElement(selection);
            if (target instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)target;
                IJavaElement parent = fragment.getParent();
                if (!(parent instanceof IPackageFragmentRoot)) return target;
                try {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                    if (!root.exists()) {
                        this.createPackageFragmentRoot(root);
                    }
                    if (fragment.exists()) return target;
                    root.createPackageFragment(fragment.getElementName(), true, (IProgressMonitor)new NullProgressMonitor());
                    return target;
                }
                catch (CoreException exception) {
                    JavaManipulationPlugin.log(exception);
                    return null;
                }
            }
            if (!(target instanceof IFolder)) return target;
            try {
                IFolder folder = (IFolder)target;
                IProject project = folder.getProject();
                if (!project.exists()) {
                    this.createJavaProject(project);
                }
                if (folder.exists()) return target;
                ResourcesUtility.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
                return target;
            }
            catch (CoreException exception) {
                JavaManipulationPlugin.log(exception);
                return null;
            }
        }

        @Override
        public String getNewButtonLabel() {
            return "unused";
        }
    }
}

