/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.CoordObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BinaryOperators;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FieldReference;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class TupleTypeID
extends CoordObjectTypeID {
    private String className;
    private List<String> fieldNames;

    public TupleTypeID(List<String> fieldNames, List<TypeID> tids, CodeGeneratorContext ctxt) {
        super(TypeID.TypeKind.TUPLE, tids);
        this.fieldNames = fieldNames;
        if (!ctxt.hasTypeName(this)) {
            this.className = ctxt.makeUniqueName("TupleType");
            ctxt.addTypeName(this, this.className);
            this.addSelf(tids, ctxt);
        } else {
            this.className = ctxt.getTypeName(this);
        }
    }

    @Override
    public String getTypeText() {
        Object args = "";
        int i = 0;
        while (i < this.subTypes.size()) {
            TypeID tid = (TypeID)this.subTypes.get(i);
            if (!((String)args).isEmpty()) {
                args = (String)args + ", ";
            }
            args = (String)args + tid.getTypeText() + "v" + String.valueOf(i);
            ++i;
        }
        return "tuple(" + (String)args + ")";
    }

    @Override
    public String getJavaClassType() {
        return this.className;
    }

    private static boolean isInitialValueIsEmpty(Type tp) {
        if ((tp = TypeIDCreation.dropTypeReferences(tp)) instanceof TupleType) {
            TupleType ttp = (TupleType)tp;
            for (TupleField tf : ttp.getFields()) {
                if (TupleTypeID.isInitialValueIsEmpty(tf.getType())) continue;
                return false;
            }
            return true;
        }
        if (tp instanceof ListType) {
            ListType lt = (ListType)tp;
            return lt.getInitialLength() == null;
        }
        return true;
    }

    @Override
    public void assignInitialValue(String name, Type tp, VBox box, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (TupleTypeID.isInitialValueIsEmpty(tp = TypeIDCreation.dropTypeReferences(tp))) {
            box.add(name + " = " + this.getEmptyValue(currentFile) + ";");
            return;
        }
        String var = ctxt.makeUniqueName("tuple");
        box.add(Strings.fmt((String)"%s %s = new %s(chiCoordinator);", (Object[])new Object[]{this.className, var, this.className}));
        TupleType ttp = (TupleType)tp;
        Assert.check((ttp.getFields().size() == this.subTypes.size() ? 1 : 0) != 0);
        int i = 0;
        for (TupleField tf : ttp.getFields()) {
            tp = TypeIDCreation.dropTypeReferences(tf.getType());
            String fieldName = var + ".var" + String.valueOf(i);
            ((TypeID)this.subTypes.get(i)).assignInitialValue(fieldName, tp, box, ctxt, currentFile);
            ++i;
        }
        box.add(name + " = " + var + ";");
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        String classPath = this.getJavaClassType();
        int idx = classPath.lastIndexOf(46);
        if (idx != -1) {
            jf.addImport(classPath, false);
        }
        return classPath + ".makeDefault(spec, chiCoordinator)";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)expr;
            EList exprs = te.getFields();
            List tids = Lists.listc((int)exprs.size());
            for (Expression e : exprs) {
                tids.add(TypeIDCreation.createTypeID(e.getType(), ctxt));
            }
            TypeID tupleTid = TypeIDCreation.createTupleTypeID(null, tids, ctxt);
            List code = Lists.list();
            String vName = ctxt.makeUniqueName("tuple");
            String line = tupleTid.getJavaClassType();
            line = Strings.fmt((String)"%s %s = new %s(chiCoordinator);", (Object[])new Object[]{line, vName, line});
            code.add(line);
            int i = 0;
            while (i < exprs.size()) {
                ExpressionBase fld = ExpressionBase.convertExpression((Expression)exprs.get(i), ctxt, currentFile);
                code.addAll(fld.getCode());
                line = Strings.fmt((String)"%s.var%d = %s;", (Object[])new Object[]{vName, i, fld.getValue()});
                code.add(line);
                ++i;
            }
            return ExpressionBase.makeExpression(code, vName, (PositionObject)expr);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            if (bexpr.getOp().equals((Object)BinaryOperators.PROJECTION)) {
                Assert.check((boolean)(bexpr.getRight() instanceof FieldReference));
                FieldReference tf = (FieldReference)bexpr.getRight();
                String fldName = tf.getField().getName();
                int i = 0;
                while (i < this.fieldNames.size()) {
                    if (this.fieldNames.get(i).equals(fldName)) break;
                    ++i;
                }
                Assert.check((i < this.fieldNames.size() ? 1 : 0) != 0, (Object)"Cannot find tuple field.");
                ExpressionBase lhsExpr = ExpressionBase.convertExpression(bexpr.getLeft(), ctxt, currentFile);
                String varText = lhsExpr.getValue() + ".var" + String.valueOf(i);
                return ExpressionBase.makeExpression(lhsExpr.getCode(), varText, (PositionObject)expr);
            }
            Assert.check((boolean)bexpr.getOp().equals((Object)BinaryOperators.ADDITION));
            ExpressionBase lhsExpr = ExpressionBase.convertExpression(bexpr.getLeft(), ctxt, currentFile);
            ExpressionBase rhsExpr = ExpressionBase.convertExpression(bexpr.getRight(), ctxt, currentFile);
            List code = Lists.list();
            String vName = ctxt.makeUniqueName("tuple");
            TypeID tid = TypeIDCreation.createTypeID(bexpr.getType(), ctxt);
            String line = tid.getJavaClassType();
            line = Strings.fmt((String)"%s %s = new %s(chiCoordinator);", (Object[])new Object[]{line, vName, line});
            code.add(line);
            int fldNum = 0;
            TupleType ttp = (TupleType)bexpr.getLeft().getType();
            code.addAll(lhsExpr.getCode());
            String value = ctxt.makeUniqueName("tuple");
            tid = TypeIDCreation.createTypeID(bexpr.getLeft().getType(), ctxt);
            line = Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tid.getJavaType(), value, lhsExpr.getValue()});
            code.add(line);
            int i = 0;
            while (i < ttp.getFields().size()) {
                line = Strings.fmt((String)"%s.var%d = (%s).var%d;", (Object[])new Object[]{vName, fldNum, value, i});
                code.add(line);
                ++fldNum;
                ++i;
            }
            ttp = (TupleType)bexpr.getRight().getType();
            code.addAll(rhsExpr.getCode());
            value = ctxt.makeUniqueName("tuple");
            tid = TypeIDCreation.createTypeID(bexpr.getRight().getType(), ctxt);
            line = Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tid.getJavaType(), value, rhsExpr.getValue()});
            code.add(line);
            i = 0;
            while (i < ttp.getFields().size()) {
                line = Strings.fmt((String)"%s.var%d = (%s).var%d;", (Object[])new Object[]{vName, fldNum, value, i});
                code.add(line);
                ++fldNum;
                ++i;
            }
            return ExpressionBase.makeExpression(code, vName, (PositionObject)expr);
        }
        Assert.fail((Object)("Implement handling of " + expr.toString() + " in TupleTypeID.convertExprNode."));
        return null;
    }

    private void addSelf(List<TypeID> tids, CodeGeneratorContext ctxt) {
        String vName;
        TypeID tid;
        JavaClass cls = ctxt.addJavaClass(this.className, false, null, null);
        cls.addVariable("private final ChiCoordinator chiCoordinator;");
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        int i = 0;
        while (i < tids.size()) {
            TypeID tid2 = tids.get(i);
            String line = Strings.fmt((String)"public %s var%d;", (Object[])new Object[]{tid2.getJavaType(), i});
            cls.addVariable(line);
            ++i;
        }
        JavaMethod jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator)");
        jm.lines.add("this.chiCoordinator = chiCoordinator;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm = new JavaMethod("public static " + this.className + " makeDefault(Specification spec, ChiCoordinator chiCoordinator)");
        jm.lines.add(this.className + " tuple = new %s(chiCoordinator);", new Object[]{this.className});
        VBox b = new VBox();
        int i2 = 0;
        while (i2 < tids.size()) {
            tid = tids.get(i2);
            vName = "tuple.var" + String.valueOf(i2);
            tid.assignInitialValue(vName, null, b, ctxt, cls);
            ++i2;
        }
        jm.lines.add((Box)b);
        jm.lines.add("return tuple;");
        cls.addMethod(jm);
        jm = new JavaMethod("public " + this.className + "(" + this.className + " orig, boolean deepCopy)");
        jm.lines.add("this.chiCoordinator = orig.chiCoordinator;");
        i2 = 0;
        while (i2 < tids.size()) {
            tid = tids.get(i2);
            vName = "var" + String.valueOf(i2);
            Object line = tid.hasDeepCopy() ? Strings.fmt((String)"%s = deepCopy ? (%s) : orig.%s;", (Object[])new Object[]{vName, tid.getDeepCopyName(vName, cls, true), vName}) : vName + " = orig." + vName + ";";
            jm.lines.add((String)line);
            ++i2;
        }
        cls.addMethod(jm);
        if (this.isPrintable()) {
            jm = new JavaMethod("public static " + this.className + " read(ChiCoordinator chiCoordinator, ChiFileHandle stream)");
            jm.lines.add(this.className + " result = new %s(chiCoordinator);", new Object[]{this.className});
            jm.lines.add();
            jm.lines.add("stream.expectCharacter('(');");
            i2 = 0;
            while (i2 < tids.size()) {
                if (i2 > 0) {
                    jm.lines.add("stream.expectCharacter(',');");
                }
                tid = tids.get(i2);
                vName = "var" + String.valueOf(i2);
                jm.lines.add("result.%s = %s;", new Object[]{vName, tid.getReadName("stream", cls)});
                ++i2;
            }
            jm.lines.add();
            jm.lines.add("stream.expectCharacter(')');");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        }
        if (this.isPrintable()) {
            jm = new JavaMethod("public void write(ChiFileHandle stream)");
            jm.lines.add("stream.write(\"(\");");
            i2 = 0;
            while (i2 < tids.size()) {
                if (i2 > 0) {
                    jm.lines.add("stream.write(\", \");");
                }
                tid = tids.get(i2);
                vName = "var" + String.valueOf(i2);
                jm.lines.add(tid.getWriteName("stream", vName, cls));
                ++i2;
            }
            jm.lines.add("stream.write(\")\");");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
            jm = new JavaMethod("public String toString()");
            jm.lines.add("ChiWriteMemoryFile mem = new ChiWriteMemoryFile();");
            jm.lines.add("write(mem);");
            jm.lines.add("return mem.getData();");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiWriteMemoryFile", false);
        }
        jm = new JavaMethod("public int hashCode()");
        jm.lines.add("int hash = 743;");
        i2 = 0;
        while (i2 < tids.size()) {
            tid = tids.get(i2);
            vName = "var" + String.valueOf(i2);
            jm.lines.add("hash = hash + %d * (%s);", new Object[]{i2, tid.getHashCodeName(vName, cls)});
            ++i2;
        }
        jm.lines.add("return hash;");
        cls.addMethod(jm);
        jm = new JavaMethod("public boolean equals(Object obj)");
        jm.lines.add("if (!(obj instanceof %s)) return false;", new Object[]{this.className});
        jm.lines.add(this.className + " other = (%s)obj;", new Object[]{this.className});
        i2 = 0;
        while (i2 < tids.size()) {
            tid = tids.get(i2);
            vName = "var" + String.valueOf(i2);
            jm.lines.add("if (%s) return false;", new Object[]{tid.getUnequal(vName, "other." + vName)});
            ++i2;
        }
        jm.lines.add("return true;");
        cls.addMethod(jm);
    }
}

