/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.BitSet;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;

public class DsmHelper {
    private DsmHelper() {
    }

    public static <T> T[] shuffleArray(T[] array, int[] shuffleTable) {
        int size = shuffleTable.length;
        Assert.check((array.length == size ? 1 : 0) != 0);
        Object[] result = (Object[])array.clone();
        int i = 0;
        while (i < size) {
            result[i] = array[shuffleTable[i]];
            ++i;
        }
        return result;
    }

    public static BitSet getBusNodes(Group gr) {
        if (gr.groupType == Group.GroupType.BUS) {
            return gr.members;
        }
        if (gr.isElementary()) {
            return BitSets.bitset();
        }
        BitSet result = BitSets.bitset();
        for (Group child : gr.childGroups) {
            result.or(DsmHelper.getBusNodes(child));
        }
        return result;
    }

    public static Group getBusGroup(Group gr) {
        if (gr.groupType == Group.GroupType.BUS) {
            return gr;
        }
        if (gr.groupType == Group.GroupType.CLUSTER) {
            return null;
        }
        Assert.check((gr.groupType == Group.GroupType.COLLECTION ? 1 : 0) != 0);
        for (Group child : gr.childGroups) {
            if (child.groupType != Group.GroupType.BUS) continue;
            return child;
        }
        return null;
    }

    public static Group getNonbusGroup(Group gr) {
        if (gr.groupType == Group.GroupType.BUS) {
            return null;
        }
        if (gr.groupType == Group.GroupType.CLUSTER) {
            return gr;
        }
        Assert.check((gr.groupType == Group.GroupType.COLLECTION ? 1 : 0) != 0);
        for (Group child : gr.childGroups) {
            if (child.groupType != Group.GroupType.CLUSTER) continue;
            return child;
        }
        return null;
    }
}

