/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.svgviz;

import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.options.MaxTimePointTolOption;
import org.eclipse.escet.cif.simulator.output.NullSimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.output.svgviz.RuntimeCifSvgDecls;
import org.eclipse.escet.cif.simulator.output.svgviz.ShutdownRuntimeState;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgPaintThread;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgRenderThread;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgVisualizationOption;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.svg.SvgCanvas;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgVisualizer;

public class SvgOutputComponent
extends NullSimulatorOutputComponent {
    private static final boolean DEBUG = false;
    public final RuntimeCifSvgDecls cifSvgDecls;
    public final SvgCanvas canvas;
    public final SvgRenderThread renderThread;
    public final SvgPaintThread paintThread;
    private boolean shutdownRequested = false;
    private final boolean interactive;
    private final boolean realTime;
    private final Double modelTimeDelta;
    private final int maxTimePointTol;
    private double lastTime;

    public SvgOutputComponent(RuntimeCifSvgDecls cifSvgDecls, CifSimulatorContext ctxt) {
        this.cifSvgDecls = cifSvgDecls;
        this.interactive = InputModeOption.isInteractive();
        this.realTime = FrameRateOption.isRealTimeEnabled();
        this.modelTimeDelta = FrameRateOption.getModelTimeDelta();
        this.maxTimePointTol = MaxTimePointTolOption.getMaxTimePointTol();
        SvgVisualizer visualizer = (SvgVisualizer)ControlEditor.show((String)cifSvgDecls.getSvgAbsPath(), SvgVisualizer.class, (String)"show the SVG visualizer", (!this.testMode ? 1 : 0) != 0);
        SvgException svgLoadErr = visualizer.getSvgError();
        if (svgLoadErr != null) {
            throw svgLoadErr;
        }
        this.canvas = visualizer.getSvgCanvas();
        this.canvas.path = cifSvgDecls.getSvgRelPath();
        cifSvgDecls.init(visualizer.getDocument(), visualizer.getSvgCanvas().getBridgeContext(), ctxt);
        this.paintThread = new SvgPaintThread(visualizer);
        this.renderThread = new SvgRenderThread(cifSvgDecls, visualizer, this.paintThread);
        this.renderThread.start();
        this.paintThread.start();
    }

    public void cleanup() {
        if (!this.shutdownRequested) {
            this.shutdownRequested = true;
            this.renderThread.addState(ShutdownRuntimeState.INSTANCE);
            try {
                this.renderThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                this.paintThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.checkThreadCrash();
        }
    }

    private void checkThreadCrash() {
        Throwable ex = null;
        Thread thread = null;
        ex = this.renderThread.exception.getAndSet(null);
        if (ex != null) {
            thread = this.renderThread;
        }
        if (ex == null && (ex = (Throwable)this.paintThread.exception.getAndSet(null)) != null) {
            thread = this.paintThread;
        }
        if (ex == null) {
            return;
        }
        if (ex instanceof SimulatorExitException) {
            return;
        }
        if (ex instanceof CifSimulatorException) {
            throw (CifSimulatorException)ex;
        }
        if (ex instanceof ApplicationException) {
            throw (ApplicationException)ex;
        }
        if (ex instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)ex;
        }
        String threadName = thread.getName();
        throw new RuntimeException(threadName + " crashed.", ex);
    }

    private boolean checkVisualizerClosed() {
        if (!this.canvas.isDisposed()) {
            return false;
        }
        OutputProvider.unregister((IOutputComponent)this);
        return true;
    }

    @Override
    public void initialState(RuntimeState state) {
        this.checkThreadCrash();
        if (this.checkVisualizerClosed()) {
            return;
        }
        this.renderThread.addState(state);
        this.lastTime = state.getTime();
        Assert.check((this.lastTime == 0.0 ? 1 : 0) != 0);
    }

    @Override
    public void intermediateTrajectoryState(RuntimeState state) {
        this.checkThreadCrash();
        if (this.checkVisualizerClosed()) {
            return;
        }
        this.renderThread.addState(state);
        this.lastTime = state.getTime();
    }

    @Override
    public void transitionTaken(RuntimeState sourceState, Transition<?> transition, RuntimeState targetState, Boolean interrupted) {
        if (this.generateFrame(transition, targetState)) {
            this.checkThreadCrash();
            if (this.checkVisualizerClosed()) {
                return;
            }
            this.renderThread.addState(targetState);
            this.lastTime = targetState.getTime();
        }
    }

    private boolean generateFrame(Transition<?> transition, RuntimeState targetState) {
        if (this.interactive) {
            return true;
        }
        if (!this.realTime) {
            return true;
        }
        if (transition instanceof EventTransition) {
            return false;
        }
        Assert.check((boolean)(transition instanceof TimeTransition));
        double targetTime = targetState.getTime();
        double nextMultiple = this.lastTime + this.modelTimeDelta;
        return Precision.equals((double)targetTime, (double)nextMultiple, (int)this.maxTimePointTol);
    }

    private void debug(String txt) {
        System.out.println(this.getClass().getSimpleName() + ": " + txt);
    }

    public static OptionCategory getOptions() {
        List subCats = Lists.list();
        List opts = Lists.list();
        opts.add(Options.getInstance(SvgVisualizationOption.class));
        return new OptionCategory("SVG visualization", "SVG visualization options.", subCats, opts);
    }

    @Override
    public boolean hasVisualInterface() {
        return !this.testMode && !this.canvas.isDisposed();
    }

    @Override
    public boolean supportsRealTimeSimulation() {
        return true;
    }
}

