/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StateInvPredCodeGenerator {
    private StateInvPredCodeGenerator() {
    }

    public static void gencodeStateInvPreds(Specification spec, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("StateInvPreds");
        CodeBox h = file.header;
        h.add("/** State invariants. */");
        h.add("public final class StateInvPreds {");
        CodeBox c = file.body;
        List invsComps = Lists.list();
        StateInvPredCodeGenerator.collectInvsComps((ComplexComponent)spec, invsComps);
        int subMethodCount = (int)Math.ceil((double)invsComps.size() / 100.0);
        c.add("public static boolean evalStateInvPreds(State state, boolean initial) {");
        c.indent();
        c.add("// Invariants not in locations of automata.");
        int i = 0;
        while (i < subMethodCount) {
            c.add("if (!evalStateInvPreds%d(state, initial)) return false;", new Object[]{i});
            ++i;
        }
        c.add();
        c.add("// Invariants for current locations of automata.");
        for (Automaton aut : ctxt.getAutomata()) {
            c.add("if (!evalStateInvPreds%s(state, initial)) return false;", new Object[]{ctxt.getAutClassName(aut)});
        }
        c.add();
        c.add("// All invariant predicates satisfied.");
        c.add("return true;");
        c.dedent();
        c.add("}");
        StateInvPredCodeGenerator.gencodeEvalInvariants(invsComps, ctxt, c);
        for (Automaton aut : ctxt.getAutomata()) {
            StateInvPredCodeGenerator.gencodeEvalAutLocs(aut, ctxt, c);
        }
    }

    private static void gencodeEvalInvariants(List<Pair<Invariant, ComplexComponent>> invsComps, CifCompilerContext ctxt, CodeBox c) {
        if (invsComps.isEmpty()) {
            return;
        }
        c.add();
        c.add("private static boolean evalStateInvPreds0(State state, boolean initial) {");
        c.indent();
        ComplexComponent comp = (ComplexComponent)invsComps.get((int)0).right;
        String absName = CifTextUtils.getAbsName((PositionObject)comp);
        c.add("// Invariants for \"%s\".", new Object[]{absName});
        List exprResults = Lists.list();
        int i = 0;
        while (i < invsComps.size()) {
            if (i > 0 && i % 100 == 0) {
                c.add("// All invariants satisfied.");
                c.add("return true;");
                c.dedent();
                c.add("}");
                c.add();
                c.add("private static boolean evalStateInvPreds%d(State state, boolean initial) {", new Object[]{i / 100});
                c.indent();
                comp = (ComplexComponent)invsComps.get((int)i).right;
                absName = CifTextUtils.getAbsName((PositionObject)comp);
                c.add("// Invariants for \"%s\".", new Object[]{absName});
            }
            if (comp != invsComps.get((int)i).right) {
                comp = (ComplexComponent)invsComps.get((int)i).right;
                absName = CifTextUtils.getAbsName((PositionObject)comp);
                c.add("// Invariants for \"%s\".", new Object[]{absName});
            }
            Invariant inv = (Invariant)invsComps.get((int)i).left;
            exprResults.add(StateInvPredCodeGenerator.gencodeEvalInvariant(inv, CifTextUtils.getComponentText2((ComplexComponent)comp), ctxt, c));
            ++i;
        }
        c.add("// All invariants satisfied.");
        c.add("return true;");
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult exprResult : exprResults) {
            exprResult.addExtraMethods(c);
        }
    }

    private static void gencodeEvalAutLocs(Automaton aut, CifCompilerContext ctxt, CodeBox c) {
        c.add();
        c.add("private static boolean evalStateInvPreds%s(State state, boolean initial) {", new Object[]{ctxt.getAutClassName(aut)});
        c.indent();
        c.add("// Invariants for current location.");
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        List exprResults = Lists.list();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            List locInvs = Lists.list();
            for (Invariant inv : loc.getInvariants()) {
                if (inv.getInvKind() != InvKind.STATE) continue;
                locInvs.add(inv);
            }
            if (!locInvs.isEmpty()) {
                c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                c.indent();
                for (Invariant inv : locInvs) {
                    exprResults.add(StateInvPredCodeGenerator.gencodeEvalInvariant(inv, CifTextUtils.getLocationText2((Location)loc), ctxt, c));
                }
                c.add("break;");
                c.dedent();
            }
            ++locIdx;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("// All invariants satisfied.");
        c.add("return true;");
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult exprResult : exprResults) {
            exprResult.addExtraMethods(c);
        }
    }

    private static ExprCodeGeneratorResult gencodeEvalInvariant(Invariant inv, String parentText, CifCompilerContext ctxt, CodeBox c) {
        Expression pred = inv.getPredicate();
        c.add("try {");
        c.indent();
        String predTxt = CifTextUtils.exprToStr((Expression)pred);
        ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(pred, ctxt, "state");
        c.add("if (!(%s)) {", new Object[]{result});
        c.indent();
        c.add("if (initial) warn(\"Invariant \\\"%s\\\" of %s is not satisfied.\");", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)predTxt, (int)1000)), StringEscapeUtils.escapeJava((String)parentText)});
        c.add("return false;");
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)predTxt, (int)1000)), StringEscapeUtils.escapeJava((String)parentText)});
        c.dedent();
        c.add("}");
        StateInvPredCodeGenerator.checkInvTimeConstant(inv);
        if (inv.getSupKind() == SupKind.REQUIREMENT) {
            OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{predTxt, parentText});
        }
        return result;
    }

    private static void checkInvTimeConstant(Invariant inv) {
        Assert.check((boolean)CifValueUtils.isTimeConstant((Expression)inv.getPredicate(), (Boolean)true));
    }

    public static void collectInvsComps(ComplexComponent comp, List<Pair<Invariant, ComplexComponent>> invsComps) {
        for (Invariant inv : comp.getInvariants()) {
            if (inv.getInvKind() != InvKind.STATE) continue;
            invsComps.add((Pair<Invariant, ComplexComponent>)Pair.pair((Object)inv, (Object)comp));
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                StateInvPredCodeGenerator.collectInvsComps((ComplexComponent)child, invsComps);
            }
        }
    }
}

