/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.typechecker;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public abstract class TypeChecker<TIn, TOut> {
    private final Set<SemanticProblem> problems = Sets.set();
    private boolean hasWarning = false;
    private boolean hasError = false;
    private boolean finished = false;
    private String sourceFilePath;

    public boolean isFinished() {
        return this.finished;
    }

    public void preparePostUse() {
        if (!this.finished) {
            throw new IllegalStateException("Not yet finished.");
        }
        this.problems.clear();
        this.finished = false;
    }

    public List<SemanticProblem> finalizePostUse() {
        if (this.finished) {
            throw new IllegalStateException("Already finished.");
        }
        List rslt = Sets.sortedgeneric(this.problems);
        this.problems.clear();
        this.finished = true;
        return rslt;
    }

    public void setSourceFilePath(String sourceFilePath) {
        if (this.sourceFilePath != null) {
            throw new IllegalStateException("Source file path already set.");
        }
        this.sourceFilePath = sourceFilePath;
    }

    public String getSourceFilePath() {
        if (this.sourceFilePath == null) {
            throw new IllegalStateException("Source file path not set.");
        }
        return this.sourceFilePath;
    }

    public String getSourceFileDir() {
        return Paths.getAbsFilePathDir((String)this.getSourceFilePath());
    }

    public String getSourceFileName() {
        return Paths.getFileName((String)this.getSourceFilePath());
    }

    public String resolveImport(String path) {
        return Paths.resolve((String)path, (String)this.getSourceFileDir());
    }

    public TOut typeCheck(TIn rootObj) {
        Assert.check((!this.finished ? 1 : 0) != 0, (Object)"can't start type checking: already finished");
        TOut rslt = null;
        try {
            rslt = this.transRoot(rootObj);
            Assert.notNull(rslt);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        this.finished = true;
        boolean hasErrors = this.hasError();
        if (!hasErrors && rslt == null) {
            String msg = "Type checking resulted in 'null', without errors.";
            throw new RuntimeException(msg);
        }
        return hasErrors ? null : rslt;
    }

    protected abstract TOut transRoot(TIn var1);

    public void addProblem(String message, SemanticProblemSeverity severity, TextPosition position) {
        this.addProblem(new SemanticProblem(message, severity, position));
    }

    public void addProblem(SemanticProblem problem) {
        Assert.check((!this.finished ? 1 : 0) != 0, (Object)"can't add problem to finished type checker");
        this.problems.add(problem);
        switch (problem.severity) {
            case WARNING: {
                this.hasWarning = true;
                break;
            }
            case ERROR: {
                this.hasError = true;
            }
        }
    }

    public void addWarning(String message, TextPosition position) {
        this.addProblem(message, SemanticProblemSeverity.WARNING, position);
    }

    public void addError(String message, TextPosition position) {
        this.addProblem(message, SemanticProblemSeverity.ERROR, position);
    }

    public List<SemanticProblem> getProblems() {
        return Sets.sortedgeneric(this.problems);
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean hasError() {
        return this.hasError;
    }
}

