/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public class UserAdminEventAdapter
implements UserAdminListener {
    public static final String TOPIC = "org/osgi/service/useradmin/UserAdmin";
    public static final char TOPIC_SEPARATOR = '/';
    public static final String EVENT = "event";
    public static final String SERVICE = "service";
    public static final String SERVICE_ID = "service.id";
    public static final String SERVICE_OBJECTCLASS = "service.objectClass";
    public static final String SERVICE_PID = "service.pid";
    public static final String ROLE_CREATED = "ROLE_CREATED";
    public static final String ROLE_CHANGED = "ROLE_CHANGED";
    public static final String ROLE_REMOVED = "ROLE_REMOVED";
    public static final String ROLE = "role";
    public static final String ROLE_NAME = "role.name";
    public static final String ROLE_TYPE = "role.type";
    private BundleContext context;
    private ServiceRegistration userAdminRegistration;
    private volatile ServiceTracker eventAdminTracker;

    public UserAdminEventAdapter(BundleContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        Hashtable props = new Hashtable(3);
        this.userAdminRegistration = this.context.registerService(UserAdminListener.class, (Object)this, props);
        this.eventAdminTracker = new ServiceTracker(this.context, EventAdmin.class, null);
        this.eventAdminTracker.open();
    }

    public void stop() throws Exception {
        ServiceTracker currentTracker = this.eventAdminTracker;
        if (currentTracker != null) {
            currentTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.userAdminRegistration != null) {
            this.userAdminRegistration.unregister();
            this.userAdminRegistration = null;
        }
        this.context = null;
    }

    public void roleChanged(UserAdminEvent event) {
        EventAdmin eventAdmin;
        ServiceTracker currentTracker = this.eventAdminTracker;
        EventAdmin eventAdmin2 = eventAdmin = currentTracker == null ? null : (EventAdmin)currentTracker.getService();
        if (eventAdmin != null) {
            String typename = null;
            switch (event.getType()) {
                case 1: {
                    typename = ROLE_CREATED;
                    break;
                }
                case 2: {
                    typename = ROLE_CHANGED;
                    break;
                }
                case 4: {
                    typename = ROLE_REMOVED;
                    break;
                }
                default: {
                    return;
                }
            }
            String topic = "org/osgi/service/useradmin/UserAdmin/" + typename;
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ServiceReference ref = event.getServiceReference();
            if (ref == null) {
                throw new RuntimeException("UserAdminEvent's getServiceReference() returns null.");
            }
            this.putServiceReferenceProperties(properties, ref);
            Role role = event.getRole();
            if (role == null) {
                throw new RuntimeException("UserAdminEvent's getRole() returns null.");
            }
            if (role != null) {
                properties.put(ROLE, role);
                properties.put(ROLE_NAME, role.getName());
                properties.put(ROLE_TYPE, role.getType());
            }
            properties.put(EVENT, event);
            Event convertedEvent = new Event(topic, properties);
            eventAdmin.postEvent(convertedEvent);
        }
    }

    public void putServiceReferenceProperties(Hashtable<String, Object> properties, ServiceReference ref) {
        Object o2;
        properties.put(SERVICE, ref);
        properties.put(SERVICE_ID, ref.getProperty(SERVICE_ID));
        Object o = ref.getProperty(SERVICE_PID);
        if (o != null && o instanceof String) {
            properties.put(SERVICE_PID, o);
        }
        if ((o2 = ref.getProperty("objectClass")) != null && o2 instanceof String[]) {
            properties.put(SERVICE_OBJECTCLASS, o2);
        }
    }
}

