/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringJoiner;

public class SecureUserStore {
    private static final String USER_STORE_FILE_NAME = "org.eclipse.equinox.console.jaas.file";
    private static final String PASSWORD_KEY = "password";
    private static final String ROLES_KEY = "roles";
    private static final String SSH_PREFIX = "/ssh";
    private static final String DELIMITER = "/";
    private static final int USERNAME_INDEX = 2;
    private static final int KEY_ELEMENTS_COUNT = 4;

    private SecureUserStore() {
    }

    public static String[] getUserNames() {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        HashSet<String> userNames = new HashSet<String>();
        for (Object key : users.keySet()) {
            String[] parts;
            if (!(key instanceof String) || (parts = ((String)key).split(DELIMITER)).length < 4) continue;
            userNames.add(parts[2]);
        }
        return userNames.toArray(new String[0]);
    }

    public static String getPassword(String username) {
        return SecureUserStore.getProperty(username, PASSWORD_KEY);
    }

    public static String getRoles(String username) {
        return SecureUserStore.getProperty(username, ROLES_KEY);
    }

    public static void putUser(String username, String password, String roles) {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        if (SecureUserStore.existsUser(username, users)) {
            throw new IllegalArgumentException("The user already exists!");
        }
        if (roles == null) {
            roles = "";
        }
        String userPassKey = SecureUserStore.constructPropertyName(username, PASSWORD_KEY);
        String userRolesKey = SecureUserStore.constructPropertyName(username, ROLES_KEY);
        users.put(userPassKey, password);
        users.put(userRolesKey, roles);
        SecureUserStore.storeProperties(users, userFileLoc);
    }

    public static void addRoles(String username, String roles) {
        if (roles == null || roles.length() == 0) {
            return;
        }
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        String userRolesKey = SecureUserStore.constructPropertyName(username, ROLES_KEY);
        String currentRoles = (String)users.remove(userRolesKey);
        HashSet rolesSet = new HashSet();
        if (currentRoles.length() > 0) {
            Collections.addAll(rolesSet, currentRoles.split(","));
        }
        Collections.addAll(rolesSet, roles.split(","));
        StringBuilder builder = new StringBuilder();
        for (String role : rolesSet) {
            builder.append(role);
            builder.append(",");
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        users.put(userRolesKey, builder.toString());
        SecureUserStore.storeProperties(users, userFileLoc);
    }

    public static void removeRoles(String username, String rolesToRemove) {
        if (rolesToRemove == null || rolesToRemove.length() == 0) {
            return;
        }
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        String userRolesKey = SecureUserStore.constructPropertyName(username, ROLES_KEY);
        String currentRoles = (String)users.remove(userRolesKey);
        HashSet rolesSet = new HashSet();
        Collections.addAll(rolesSet, currentRoles.split(","));
        String[] stringArray = rolesToRemove.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            rolesSet.remove(role);
            ++n2;
        }
        StringJoiner builder = new StringJoiner(",");
        for (String role : rolesSet) {
            builder.add(role);
        }
        users.put(userRolesKey, builder.toString());
        SecureUserStore.storeProperties(users, userFileLoc);
    }

    public static void deleteUser(String username) {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        if (!SecureUserStore.existsUser(username, users)) {
            throw new IllegalArgumentException("The user does not exist!");
        }
        String rolesProperty = SecureUserStore.constructPropertyName(username, ROLES_KEY);
        String passwordProperty = SecureUserStore.constructPropertyName(username, PASSWORD_KEY);
        users.remove(rolesProperty);
        users.remove(passwordProperty);
        SecureUserStore.storeProperties(users, userFileLoc);
    }

    public static void resetPassword(String username) {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        if (!SecureUserStore.existsUser(username, users)) {
            throw new IllegalArgumentException("The user does not exist!");
        }
        for (Object key : users.keySet()) {
            if (!(key instanceof String) || !((String)key).contains(DELIMITER + username + "/password")) continue;
            users.remove(key);
            break;
        }
        SecureUserStore.storeProperties(users, userFileLoc);
    }

    public static void setPassword(String username, String password) {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        if (!SecureUserStore.existsUser(username, users)) {
            throw new IllegalArgumentException("The user does not exist!");
        }
        String passwordPropertyName = SecureUserStore.constructPropertyName(username, PASSWORD_KEY);
        for (Object key : users.keySet()) {
            if (!(key instanceof String) || !((String)key).contains(passwordPropertyName)) continue;
            users.remove(key);
            break;
        }
        users.put(passwordPropertyName, password);
        SecureUserStore.storeProperties(users, userFileLoc);
    }

    public static boolean existsUser(String username) {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        return SecureUserStore.existsUser(username, users);
    }

    public static void initStorage() throws IOException {
        String userFileLoc = SecureUserStore.getFileLocation();
        File file = new File(userFileLoc);
        if (!file.exists()) {
            Properties props = new Properties();
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                props.store(out, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static String getProperty(String username, String propertyName) {
        String userFileLoc = SecureUserStore.getFileLocation();
        Properties users = SecureUserStore.loadProperties(userFileLoc);
        return users.getProperty(SecureUserStore.constructPropertyName(username, propertyName));
    }

    private static String getFileLocation() {
        String userFileLoc = System.getProperty(USER_STORE_FILE_NAME);
        if (userFileLoc == null) {
            throw new IllegalArgumentException("Property org.eclipse.equinox.console.jaas.file is not set; cannot use JAAS authentication");
        }
        return userFileLoc;
    }

    private static String constructPropertyName(String user, String propertyName) {
        StringBuilder builder = new StringBuilder();
        builder.append(SSH_PREFIX);
        builder.append(DELIMITER);
        builder.append(user);
        builder.append(DELIMITER);
        builder.append(propertyName);
        return builder.toString();
    }

    private static boolean existsUser(String username, Properties users) {
        for (Object user : users.keySet()) {
            if (!(user instanceof String) || !((String)user).contains(DELIMITER + username + DELIMITER)) continue;
            return true;
        }
        return false;
    }

    private static Properties loadProperties(String filePath) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (FileInputStream in = new FileInputStream(filePath);){
                Properties properties = new Properties();
                properties.load(in);
                return properties;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + filePath + " does not exist");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load properties from file " + filePath);
        }
    }

    private static void storeProperties(Properties properties, String filePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(filePath);){
                properties.store(out, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot store properties in file " + filePath);
        }
    }
}

