/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.RegistryHttpClient;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryDeniedException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.QueryExecHTTP;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    public static final String base = "http://jena.apache.org/ARQ#";
    public static final Symbol serviceParams = ARQ.serviceParams;
    public static final Symbol httpServiceAllowed = ARQ.httpServiceAllowed;
    public static final Symbol httpQueryClient = ARQ.httpQueryClient;
    public static final Symbol httpServiceSendMode = ARQ.httpServiceSendMode;
    public static final Symbol httpQueryTimeout = ARQ.httpQueryTimeout;
    private static Context emptyContext = Context.emptyContext();
    public static final String baseOld = "http://jena.hpl.hp.com/Service#";
    public static final Symbol oldQueryClient = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryClient");
    public static final Symbol oldServiceContext = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceContext");
    public static final Symbol oldServiceAllowed = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceAllowed");
    public static final Symbol oldQueryTimeout = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryTimeout");
    public static final Symbol oldQueryCompression = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryCompression");
    public static final Symbol serviceAllowed = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceAllowed");

    private Service() {
    }

    private static void checkForOldParameters(Context context2) {
        if (context2 == null) {
            return;
        }
        Service.checkForOldParameter(context2, oldQueryClient);
        Service.checkForOldParameter(context2, oldServiceContext);
        Service.checkForOldParameter(context2, oldServiceAllowed);
        Service.checkForOldParameter(context2, oldQueryTimeout);
        Service.checkForOldParameter(context2, oldQueryCompression);
    }

    private static void checkForOldParameter(Context context2, Symbol oldSymbol) {
        if (context2.isDefined(oldSymbol)) {
            Log.warnOnce(LOGGER, "Service context parameter '" + oldSymbol.getSymbol() + "' no longer used - see ARQ constants for replacements.", (Object)oldSymbol);
        }
    }

    public static void checkServiceAllowed(Context context2) {
        Boolean b2;
        Boolean b1;
        if (!ARQ.globalServiceAllowed) {
            Service.serviceDisabled();
        }
        if (context2 == null) {
            context2 = ARQ.getContext();
        }
        if ((b1 = Service.getBoolean(context2, httpServiceAllowed)) != null) {
            if (b1.booleanValue()) {
                return;
            }
            Service.serviceNotEnabled();
        }
        if ((b2 = Service.getBoolean(context2, oldServiceAllowed)) != null) {
            if (b2.booleanValue()) {
                return;
            }
            Service.serviceNotEnabled();
        }
        if (!ARQ.allowServiceDefault) {
            Service.serviceNotEnabled();
        }
    }

    private static Boolean getBoolean(Context context2, Symbol symbol) {
        try {
            return context2.getTrueOrFalse(httpServiceAllowed);
        }
        catch (Throwable ex) {
            throw new QueryException("Failed to read content setting  " + symbol.getSymbol());
        }
    }

    private static void serviceNotEnabled() {
        throw new QueryDeniedException("SERVICE execution disabled - enable with " + httpServiceAllowed);
    }

    private static void serviceDisabled() {
        throw new QueryDeniedException("SERVICE execution disabled");
    }

    public static QueryIterator exec(OpService op, Context context2) {
        Service.checkServiceAllowed(context2);
        if (context2 == null) {
            context2 = emptyContext;
        }
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        boolean silent = op.getSilent();
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        String serviceURL = op.getService().getURI();
        Op opRemote = op.getSubOp();
        Op opRestored = Rename.reverseVarRename(opRemote, true);
        Query query = OpAsQuery.asQuery(opRestored);
        boolean requiresRemapping = false;
        HashMap<Var, Var> varMapping = null;
        if (!opRestored.equals(opRemote)) {
            varMapping = new HashMap<Var, Var>();
            Set<Var> originalVars = OpVars.visibleVars(op);
            Set<Var> remoteVars = OpVars.visibleVars(opRestored);
            for (Var v : originalVars) {
                if (v.getName().contains("/")) {
                    String origName = v.getName().substring(v.getName().lastIndexOf(47) + 1);
                    Var remoteVar = Var.alloc(origName);
                    if (!remoteVars.contains(remoteVar)) continue;
                    varMapping.put(remoteVar, v);
                    requiresRemapping = true;
                    continue;
                }
                if (!remoteVars.contains(v)) continue;
                varMapping.put(v, v);
            }
        }
        long timeoutMillis = Service.timeoutFromContext(context2);
        Params serviceParams = Service.getServiceParamsFromContext(serviceURL, context2);
        HttpClient httpClient = Service.chooseHttpClient(serviceURL, context2);
        QuerySendMode querySendMode = Service.chooseQuerySendMode(serviceURL, context2, QuerySendMode.asGetWithLimitBody);
        QueryExecHTTP qExec = (QueryExecHTTP)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)QueryExecHTTP.newBuilder().endpoint(serviceURL)).timeout(timeoutMillis, TimeUnit.MILLISECONDS)).query(query)).params(serviceParams)).context(context2)).httpClient(httpClient)).sendMode(querySendMode)).build();
        try {
            RowSet rowSet = qExec.select().materialize();
            QueryIterator qIter = QueryIterPlainWrapper.create(rowSet);
            if (requiresRemapping) {
                qIter = QueryIter.map(qIter, varMapping);
            }
            return qIter;
        }
        catch (HttpException ex) {
            throw QueryExceptionHTTP.rewrap(ex);
        }
    }

    private static HttpClient chooseHttpClient(String serviceURL, Context context2) {
        HttpClient httpClient = (HttpClient)RegistryHttpClient.get().find(serviceURL);
        if (httpClient == null && context2 != null) {
            Object client;
            if (context2.isDefined(oldQueryClient)) {
                LOGGER.warn("Deprecated context symbol " + oldQueryClient + ". See " + httpQueryClient + ".");
            }
            if ((client = context2.get(httpQueryClient)) != null) {
                if (client.getClass().getName().equals("org.apache.http.client.HttpClient")) {
                    LOGGER.warn("Found Apache HttpClient for context symbol " + httpQueryClient + ". Jena now uses java.net.http.HttpClient");
                    client = null;
                } else if (client instanceof HttpClient) {
                    httpClient = (HttpClient)client;
                } else {
                    LOGGER.warn("Not recognized " + httpQueryClient + " -> " + client);
                }
            }
        }
        if (httpClient == null) {
            httpClient = HttpEnv.getDftHttpClient();
        }
        return httpClient;
    }

    private static QuerySendMode chooseQuerySendMode(String serviceURL, Context context2, QuerySendMode dftValue) {
        if (context2 == null) {
            return dftValue;
        }
        QuerySendMode querySendMode = context2.get(httpServiceSendMode, dftValue);
        if (querySendMode == null) {
            return dftValue;
        }
        if (querySendMode instanceof QuerySendMode) {
            return querySendMode;
        }
        if (querySendMode instanceof String) {
            String str2 = (String)((Object)querySendMode);
            if ("POST".equalsIgnoreCase(str2)) {
                return QuerySendMode.asPost;
            }
            if ("GET".equalsIgnoreCase(str2)) {
                return QuerySendMode.asGetAlways;
            }
            try {
                return QuerySendMode.valueOf((String)((Object)querySendMode));
            }
            catch (IllegalArgumentException ex) {
                throw new QueryExecException("Failed to interpret '" + (Object)((Object)querySendMode) + "' as a query send mode");
            }
        }
        FmtLog.warn(Service.class, "Unrecognized object type '%s' as a query send mode - ignored", ((Object)((Object)querySendMode)).getClass().getSimpleName());
        return dftValue;
    }

    static long timeoutFromContext(Context context2) {
        return Service.parseTimeout(context2.get(httpQueryTimeout));
    }

    static long parseTimeout(Object obj) {
        if (obj == null) {
            return -1L;
        }
        try {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            LOGGER.warn("Can't interpret timeout: " + obj);
            return -1L;
        }
        catch (Exception ex) {
            LOGGER.warn("Exception setting timeout (context) from: " + obj);
            return -1L;
        }
    }

    static Params getServiceParamsFromContext(String serviceURI, Context context2) throws QueryExecException {
        Params params = Params.create();
        Object obj = context2.get(serviceParams);
        if (obj == null) {
            return params;
        }
        try {
            Map paramsMap;
            Map serviceParams = (Map)obj;
            if (serviceParams != null && (paramsMap = (Map)serviceParams.get(serviceURI)) != null) {
                for (String param : paramsMap.keySet()) {
                    if ("query".equals(param)) {
                        throw new QueryExecException("ARQ serviceParams overrides the 'query' SPARQL protocol parameter");
                    }
                    List values = (List)paramsMap.get(param);
                    for (String value : values) {
                        params.add(param, value);
                    }
                }
            }
            return params;
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to process " + obj + " : context value of ARQ.serviceParams");
            return null;
        }
    }
}

