/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process;

import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFApply
extends StreamRDFWrapper {
    private final Function<Node, Node> gFunction;
    private final Function<Node, Node> sFunction;
    private final Function<Node, Node> pFunction;
    private final Function<Node, Node> oFunction;

    public StreamRDFApply(StreamRDF other, Function<Node, Node> sFunction, Function<Node, Node> pFunction, Function<Node, Node> oFunction) {
        this(other, null, sFunction, pFunction, oFunction);
    }

    public StreamRDFApply(StreamRDF other, Function<Node, Node> gFunction, Function<Node, Node> sFunction, Function<Node, Node> pFunction, Function<Node, Node> oFunction) {
        super(other);
        this.gFunction = gFunction;
        this.sFunction = sFunction;
        this.pFunction = pFunction;
        this.oFunction = oFunction;
    }

    private static Node applyFunction(Node node, Function<Node, Node> function) {
        if (function == null) {
            return node;
        }
        Node node2 = function.apply(node);
        if (node2 == null) {
            return node;
        }
        return node2;
    }

    @Override
    public void triple(Triple triple) {
        Node subj = triple.getSubject();
        Node subj2 = StreamRDFApply.applyFunction(subj, this.sFunction);
        Node pred = triple.getPredicate();
        Node pred2 = StreamRDFApply.applyFunction(pred, this.pFunction);
        Node obj = triple.getObject();
        Node obj2 = StreamRDFApply.applyFunction(obj, this.oFunction);
        if (subj != subj2 || pred != pred2 || obj != obj2) {
            triple = Triple.create(subj2, pred2, obj2);
        }
        super.triple(triple);
    }

    @Override
    public void quad(Quad quad) {
        Node gName = quad.getGraph();
        Node gName2 = StreamRDFApply.applyFunction(gName, this.gFunction);
        Node subj = quad.getSubject();
        Node subj2 = StreamRDFApply.applyFunction(subj, this.sFunction);
        Node pred = quad.getPredicate();
        Node pred2 = StreamRDFApply.applyFunction(subj, this.pFunction);
        Node obj = quad.getObject();
        Node obj2 = StreamRDFApply.applyFunction(obj, this.oFunction);
        if (subj != subj2 || pred != pred2 || obj != obj2 || gName != gName2) {
            quad = Quad.create(gName2, subj2, pred2, obj2);
        }
        super.quad(quad);
    }
}

