/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ProcessingRuntime;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Optional;

public final class ExpansionProcessor {
    ExpansionProcessor() {
    }

    public static final JsonArray expand(URI input, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + input + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return ExpansionProcessor.expand(remoteDocument, options, false);
    }

    public static final JsonArray expand(Document input, JsonLdOptions options, boolean frameExpansion) throws JsonLdError {
        JsonObject object;
        JsonValue expanded;
        Optional<JsonStructure> contextValue;
        if (input == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "RemoteDocument is null.");
        }
        JsonStructure jsonStructure = input.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document is not pased JSON."));
        URI baseUri = null;
        URI baseUrl = null;
        if (input.getDocumentUrl() != null) {
            baseUri = baseUrl = input.getDocumentUrl();
        }
        if (baseUrl == null) {
            baseUrl = options.getBase();
        }
        if (options.getBase() != null) {
            baseUri = options.getBase();
        }
        ActiveContext activeContext = new ActiveContext(baseUri, baseUrl, ProcessingRuntime.of(options));
        if (options.getExpandContext() != null && (contextValue = options.getExpandContext().getJsonContent()).isPresent()) {
            activeContext = ExpansionProcessor.updateContext(activeContext, contextValue.get(), baseUrl);
        }
        if (input.getContextUrl() != null) {
            activeContext = activeContext.newContext().create(JsonProvider.instance().createValue(input.getContextUrl().toString()), input.getContextUrl());
        }
        if (JsonUtils.isObject(expanded = Expansion.with(activeContext, jsonStructure, null, baseUrl).frameExpansion(frameExpansion).ordered(options.isOrdered()).compute()) && (object = expanded.asJsonObject()).size() == 1 && object.containsKey("@graph")) {
            expanded = (JsonValue)object.get("@graph");
        }
        if (JsonUtils.isNull(expanded)) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        return JsonUtils.toJsonArray(expanded);
    }

    private static final ActiveContext updateContext(ActiveContext activeContext, JsonValue expandedContext, URI baseUrl) throws JsonLdError {
        if (JsonUtils.isArray(expandedContext)) {
            JsonValue value;
            if (expandedContext.asJsonArray().size() == 1 && JsonUtils.containsKey(value = (JsonValue)expandedContext.asJsonArray().iterator().next(), "@context")) {
                return activeContext.newContext().create((JsonValue)value.asJsonObject().get("@context"), baseUrl);
            }
            return activeContext.newContext().create(expandedContext, baseUrl);
        }
        if (JsonUtils.containsKey(expandedContext, "@context")) {
            return activeContext.newContext().create((JsonValue)expandedContext.asJsonObject().get("@context"), baseUrl);
        }
        return activeContext.newContext().create(JsonProvider.instance().createArrayBuilder().add(expandedContext).build(), baseUrl);
    }
}

