/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.api.CompactionApi;
import com.apicatalog.jsonld.api.ExpansionApi;
import com.apicatalog.jsonld.api.FlatteningApi;
import com.apicatalog.jsonld.api.FramingApi;
import com.apicatalog.jsonld.api.FromRdfApi;
import com.apicatalog.jsonld.api.ToRdfApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;

public final class JsonLd {
    private static final String DOCUMENT_LOCATION_PARAM_NAME = "documentLocation";
    private static final String DOCUMENT_URI_PARAM_NAME = "documentUri";
    private static final String DOCUMENT_PARAM_NAME = "document";
    private static final String CONTEXT_PARAM_NAME = "context";
    private static final String FRAME_LOCATION_PARAM_NAME = "frameLocation";
    private static final String FRAME_URI_PARAM_NAME = "frameUri";
    private static final String FRAME_PARAM_NAME = "frame";

    private JsonLd() {
    }

    public static final ExpansionApi expand(String documentLocation) {
        return new ExpansionApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final ExpansionApi expand(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new ExpansionApi(documentUri);
    }

    public static final ExpansionApi expand(Document document) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        return new ExpansionApi(document);
    }

    public static final CompactionApi compact(String documentLocation, String contextLocation) {
        return JsonLd.compact(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME), JsonLd.assertLocation(contextLocation, "contextLocation"));
    }

    public static final CompactionApi compact(URI documentUri, URI contextUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        JsonLd.assertUri(contextUri, "contextUri");
        return new CompactionApi(documentUri, contextUri);
    }

    public static final CompactionApi compact(String documentLocation, Document context2) {
        JsonLd.assertJsonDocument(context2, CONTEXT_PARAM_NAME);
        return new CompactionApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME), context2);
    }

    public static final CompactionApi compact(URI documentUri, Document context2) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        JsonLd.assertJsonDocument(context2, CONTEXT_PARAM_NAME);
        return new CompactionApi(documentUri, context2);
    }

    public static final CompactionApi compact(Document document, Document context2) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        JsonLd.assertJsonDocument(context2, CONTEXT_PARAM_NAME);
        return new CompactionApi(document, context2);
    }

    public static final CompactionApi compact(Document document, String contextLocation) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        return JsonLd.compact(document, JsonLd.assertLocation(contextLocation, "contextLocation"));
    }

    public static final CompactionApi compact(Document document, URI contextUri) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        JsonLd.assertUri(contextUri, "contextUri");
        return new CompactionApi(document, contextUri);
    }

    public static final CompactionApi compact(String documentLocation, URI contextUri) {
        JsonLd.assertUri(contextUri, "contextUri");
        return new CompactionApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME), contextUri);
    }

    public static final CompactionApi compact(URI documentUri, String contextLocation) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new CompactionApi(documentUri, JsonLd.assertLocation(contextLocation, "contextLocation"));
    }

    public static final FlatteningApi flatten(String documentLocation) {
        return new FlatteningApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final FlatteningApi flatten(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new FlatteningApi(documentUri);
    }

    public static final FlatteningApi flatten(Document document) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        return new FlatteningApi(document);
    }

    public static final FramingApi frame(URI documentUri, URI frameUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        JsonLd.assertUri(frameUri, FRAME_URI_PARAM_NAME);
        return new FramingApi(documentUri, frameUri);
    }

    public static final FramingApi frame(String documentLocation, String frameLocation) {
        return new FramingApi(JsonLd.assertLocation(documentLocation, DOCUMENT_URI_PARAM_NAME), JsonLd.assertLocation(frameLocation, FRAME_LOCATION_PARAM_NAME));
    }

    public static final FramingApi frame(Document document, Document frame) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        JsonLd.assertJsonDocument(frame, FRAME_PARAM_NAME);
        return new FramingApi(document, frame);
    }

    public static final FramingApi frame(Document document, String frameLocation) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        return new FramingApi(document, JsonLd.assertLocation(frameLocation, FRAME_LOCATION_PARAM_NAME));
    }

    public static final FramingApi frame(Document document, URI frameUri) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        JsonLd.assertUri(frameUri, FRAME_URI_PARAM_NAME);
        return new FramingApi(document, frameUri);
    }

    public static final FramingApi frame(String documentLocation, Document frame) {
        JsonLd.assertJsonDocument(frame, FRAME_PARAM_NAME);
        return new FramingApi(JsonLd.assertLocation(documentLocation, DOCUMENT_URI_PARAM_NAME), frame);
    }

    public static final FramingApi frame(String documentLocation, URI frameUri) {
        JsonLd.assertUri(frameUri, FRAME_URI_PARAM_NAME);
        return new FramingApi(JsonLd.assertLocation(documentLocation, DOCUMENT_URI_PARAM_NAME), frameUri);
    }

    public static final FramingApi frame(URI documentUri, Document frame) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        JsonLd.assertJsonDocument(frame, FRAME_PARAM_NAME);
        return new FramingApi(documentUri, frame);
    }

    public static final FramingApi frame(URI documentUri, String frameLocation) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new FramingApi(documentUri, JsonLd.assertLocation(frameLocation, FRAME_LOCATION_PARAM_NAME));
    }

    public static final ToRdfApi toRdf(String documentLocation) {
        return new ToRdfApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final ToRdfApi toRdf(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new ToRdfApi(documentUri);
    }

    public static final ToRdfApi toRdf(Document document) {
        JsonLd.assertJsonDocument(document, DOCUMENT_PARAM_NAME);
        return new ToRdfApi(document);
    }

    public static final FromRdfApi fromRdf(String documentLocation) {
        return new FromRdfApi(JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME));
    }

    public static final FromRdfApi fromRdf(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new FromRdfApi(documentUri);
    }

    public static final FromRdfApi fromRdf(Document document) {
        JsonLd.assertRdfDocument(document, DOCUMENT_PARAM_NAME);
        return new FromRdfApi(document);
    }

    private static final URI assertLocation(String location, String param) {
        JsonLd.assertNotNull(location, param);
        if (StringUtils.isBlank(location)) {
            throw new IllegalArgumentException("'" + param + "' is blank string.");
        }
        URI uri = UriUtils.create(StringUtils.strip(location));
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("'" + param + "' is not an absolute URI [" + location + "].");
        }
        return uri;
    }

    private static final void assertUri(URI uri, String param) {
        JsonLd.assertNotNull(uri, param);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("'" + param + "' is not an absolute URI [" + uri + "].");
        }
    }

    private static final void assertJsonDocument(Document document, String param) {
        JsonLd.assertNotNull(document, param);
        if (!document.getJsonContent().isPresent()) {
            throw new IllegalArgumentException("'" + param + "' is not not JSON document but [" + document.getContentType() + "].");
        }
    }

    private static final void assertRdfDocument(Document document, String param) {
        JsonLd.assertNotNull(document, param);
        if (!document.getRdfContent().isPresent()) {
            throw new IllegalArgumentException("'" + param + "' is not not RDF document but [" + document.getContentType() + "].");
        }
    }

    private static final void assertNotNull(Object value, String param) {
        if (value == null) {
            throw new IllegalArgumentException("'" + param + "' is null.");
        }
    }
}

