/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.routing;

import java.util.Collection;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoopLabels;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.AbstractSelfLoopRouter;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.math.Spacing;
import org.eclipse.elk.core.options.PortSide;

public class OrthogonalSelfLoopRouter
extends AbstractSelfLoopRouter {
    @Override
    public void routeSelfLoops(SelfLoopHolder slHolder) {
        LNode lNode = slHolder.getLNode();
        KVector nodeSize = lNode.getSize();
        LMargin nodeMargins = lNode.getMargin();
        double edgeEdgeDistance = LGraphUtil.getIndividualOrInherited(lNode, LayeredOptions.SPACING_EDGE_EDGE);
        double edgeLabelDistance = LGraphUtil.getIndividualOrInherited(lNode, LayeredOptions.SPACING_EDGE_LABEL);
        double nodeSLDistance = LGraphUtil.getIndividualOrInherited(lNode, LayeredOptions.SPACING_NODE_SELF_LOOP);
        LMargin newNodeMargins = new LMargin();
        newNodeMargins.set((Spacing)nodeMargins);
        double[][] routingSlotPositions = this.computeRoutingSlotPositions(slHolder, edgeEdgeDistance, edgeLabelDistance, nodeSLDistance);
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            for (SelfLoopEdge slEdge : slLoop.getSLEdges()) {
                LEdge lEdge = slEdge.getLEdge();
                EdgeRoutingDirection routingDirection = this.computeEdgeRoutingDirection(slEdge);
                KVectorChain bendPoints = this.computeOrthogonalBendPoints(slEdge, routingDirection, routingSlotPositions);
                bendPoints = this.modifyBendPoints(slEdge, routingDirection, bendPoints);
                lEdge.getBendPoints().clear();
                lEdge.getBendPoints().addAll((Collection)bendPoints);
                bendPoints.stream().forEach(bp -> this.updateNewNodeMargins(nodeSize, newNodeMargins, (KVector)bp));
            }
            SelfHyperLoopLabels slLabels = slLoop.getSLLabels();
            if (slLabels == null) continue;
            this.placeLabels(slLoop, slLabels, routingSlotPositions, edgeLabelDistance);
            this.updateNewNodeMargins(nodeSize, newNodeMargins, slLabels);
        }
        nodeMargins.set((Spacing)newNodeMargins);
    }

    private EdgeRoutingDirection computeEdgeRoutingDirection(SelfLoopEdge slEdge) {
        LPort targetLPort;
        PortSide targetPortSide;
        LPort sourceLPort = slEdge.getSLSource().getLPort();
        PortSide sourcePortSide = sourceLPort.getSide();
        if (sourcePortSide == (targetPortSide = (targetLPort = slEdge.getSLTarget().getLPort()).getSide())) {
            return sourceLPort.id < targetLPort.id ? EdgeRoutingDirection.CLOCKWISE : EdgeRoutingDirection.COUNTER_CLOCKWISE;
        }
        if (sourcePortSide.right() == targetPortSide) {
            return EdgeRoutingDirection.CLOCKWISE;
        }
        if (sourcePortSide.left() == targetPortSide) {
            return EdgeRoutingDirection.COUNTER_CLOCKWISE;
        }
        assert (sourcePortSide.opposed() == targetPortSide);
        SelfHyperLoop slLoop = slEdge.getSLHyperLoop();
        if (slLoop.getOccupiedPortSides().contains(sourcePortSide.right())) {
            return EdgeRoutingDirection.CLOCKWISE;
        }
        assert (slLoop.getOccupiedPortSides().contains(sourcePortSide.left()));
        return EdgeRoutingDirection.COUNTER_CLOCKWISE;
    }

    private void placeLabels(SelfHyperLoop slLoop, SelfHyperLoopLabels slLabels, double[][] routingSlotPositions, double edgeLabelDistance) {
        PortSide labelSide = slLabels.getSide();
        double labelPosition = routingSlotPositions[labelSide.ordinal()][slLoop.getRoutingSlot(labelSide)];
        boolean inline = false;
        for (LLabel label : slLabels.getLLabels()) {
            if (!((Boolean)label.getProperty(LayeredOptions.EDGE_LABELS_INLINE)).booleanValue()) continue;
            inline = true;
            break;
        }
        if (inline) {
            edgeLabelDistance = 0.0;
        }
        switch (labelSide) {
            case NORTH: {
                slLabels.getPosition().y = labelPosition -= edgeLabelDistance + slLabels.getSize().y;
                break;
            }
            case SOUTH: {
                slLabels.getPosition().y = labelPosition += edgeLabelDistance;
                break;
            }
            case WEST: {
                slLabels.getPosition().x = labelPosition -= edgeLabelDistance + slLabels.getSize().x;
                break;
            }
            case EAST: {
                slLabels.getPosition().x = labelPosition += edgeLabelDistance;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void updateNewNodeMargins(KVector nodeSize, LMargin newNodeMargins, KVector bendPoint) {
        newNodeMargins.left = Math.max(newNodeMargins.left, -bendPoint.x);
        newNodeMargins.right = Math.max(newNodeMargins.right, bendPoint.x - nodeSize.x);
        newNodeMargins.top = Math.max(newNodeMargins.top, -bendPoint.y);
        newNodeMargins.bottom = Math.max(newNodeMargins.bottom, bendPoint.y - nodeSize.y);
    }

    private void updateNewNodeMargins(KVector nodeSize, LMargin newNodeMargins, SelfHyperLoopLabels slLabels) {
        KVector pos = new KVector(slLabels.getPosition());
        this.updateNewNodeMargins(nodeSize, newNodeMargins, pos);
        pos.add(slLabels.getSize());
        this.updateNewNodeMargins(nodeSize, newNodeMargins, pos);
    }

    private double[][] computeRoutingSlotPositions(SelfLoopHolder slHolder, double edgeEdgeDistance, double edgeLabelDistance, double nodeSLDistance) {
        double[][] positions = new double[PortSide.values().length][];
        PortSide[] portSideArray = PortSide.values();
        int n = portSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortSide portSide = portSideArray[n2];
            positions[portSide.ordinal()] = new double[slHolder.getRoutingSlotCount()[portSide.ordinal()]];
            ++n2;
        }
        this.initializeWithMaxLabelHeight(positions, slHolder, PortSide.NORTH);
        this.initializeWithMaxLabelHeight(positions, slHolder, PortSide.SOUTH);
        this.computePositions(positions, slHolder, PortSide.NORTH, edgeEdgeDistance, edgeLabelDistance, nodeSLDistance);
        this.computePositions(positions, slHolder, PortSide.EAST, edgeEdgeDistance, edgeLabelDistance, nodeSLDistance);
        this.computePositions(positions, slHolder, PortSide.SOUTH, edgeEdgeDistance, edgeLabelDistance, nodeSLDistance);
        this.computePositions(positions, slHolder, PortSide.WEST, edgeEdgeDistance, edgeLabelDistance, nodeSLDistance);
        return positions;
    }

    private void initializeWithMaxLabelHeight(double[][] positions, SelfLoopHolder slHolder, PortSide portSide) {
        assert (portSide == PortSide.NORTH || portSide == PortSide.SOUTH);
        double[] sidePositions = positions[portSide.ordinal()];
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            SelfHyperLoopLabels slLabels = slLoop.getSLLabels();
            if (slLabels == null || slLabels.getSide() != portSide) continue;
            int routingSlot = slLoop.getRoutingSlot(portSide);
            sidePositions[routingSlot] = Math.max(sidePositions[routingSlot], slLabels.getSize().y);
        }
    }

    private void computePositions(double[][] positions, SelfLoopHolder slHolder, PortSide portSide, double edgeEdgeDistance, double edgeLabelDistance, double nodeSelfLoopDistance) {
        double currPos = this.computeBaselinePosition(slHolder, portSide, nodeSelfLoopDistance);
        double factor = portSide == PortSide.NORTH || portSide == PortSide.WEST ? -1 : 1;
        double[] sidePositions = positions[portSide.ordinal()];
        int slot = 0;
        while (slot < sidePositions.length) {
            double largestLabelSize = sidePositions[slot];
            if (largestLabelSize > 0.0) {
                largestLabelSize += edgeLabelDistance;
            }
            sidePositions[slot] = currPos;
            currPos += factor * (largestLabelSize + edgeEdgeDistance);
            ++slot;
        }
    }

    private double computeBaselinePosition(SelfLoopHolder slHolder, PortSide portSide, double nodeSelfLoopDistance) {
        LNode lNode = slHolder.getLNode();
        LMargin lMargins = lNode.getMargin();
        switch (portSide) {
            case NORTH: {
                return -lMargins.top - nodeSelfLoopDistance;
            }
            case EAST: {
                return lNode.getSize().x + lMargins.right + nodeSelfLoopDistance;
            }
            case SOUTH: {
                return lNode.getSize().y + lMargins.bottom + nodeSelfLoopDistance;
            }
            case WEST: {
                return -lMargins.left - nodeSelfLoopDistance;
            }
        }
        assert (false);
        return -1.0;
    }

    protected KVectorChain computeOrthogonalBendPoints(SelfLoopEdge slEdge, EdgeRoutingDirection routingDirection, double[][] routingSlotPositions) {
        KVectorChain bendPoints = new KVectorChain();
        this.addOuterBendPoint(slEdge, slEdge.getSLSource(), routingSlotPositions, bendPoints);
        this.addCornerBendPoints(slEdge, routingDirection, routingSlotPositions, bendPoints);
        this.addOuterBendPoint(slEdge, slEdge.getSLTarget(), routingSlotPositions, bendPoints);
        return bendPoints;
    }

    protected KVectorChain modifyBendPoints(SelfLoopEdge slEdge, EdgeRoutingDirection routingDirection, KVectorChain bendPoints) {
        return bendPoints;
    }

    private void addOuterBendPoint(SelfLoopEdge slEdge, SelfLoopPort slPort, double[][] routingSlotPositions, KVectorChain bendPoints) {
        SelfHyperLoop slLoop = slEdge.getSLHyperLoop();
        LPort lPort = slPort.getLPort();
        PortSide portSide = lPort.getSide();
        KVector result = this.getBaseVector(portSide, slLoop.getRoutingSlot(portSide), routingSlotPositions);
        KVector anchor = lPort.getPosition().clone().add(lPort.getAnchor());
        switch (lPort.getSide()) {
            case NORTH: {
                result.x += anchor.x;
                break;
            }
            case SOUTH: {
                result.x += anchor.x;
                break;
            }
            case EAST: {
                result.y += anchor.y;
                break;
            }
            case WEST: {
                result.y += anchor.y;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        bendPoints.add((Object)result);
    }

    private void addCornerBendPoints(SelfLoopEdge slEdge, EdgeRoutingDirection routingDirection, double[][] routingSlotPositions, KVectorChain bendPoints) {
        LPort lSourcePort = slEdge.getSLSource().getLPort();
        LPort lTargetPort = slEdge.getSLTarget().getLPort();
        if (lSourcePort.getSide() == lTargetPort.getSide()) {
            return;
        }
        SelfHyperLoop slLoop = slEdge.getSLHyperLoop();
        PortSide labelSide = null;
        KVector lSize = null;
        boolean inline = slEdge.isInline();
        if (inline && slLoop.getSLLabels() != null) {
            labelSide = slEdge.getLabelSide();
            lSize = slLoop.getSLLabels().getSize();
        }
        PortSide currPortSide = lSourcePort.getSide();
        PortSide nextPortSide = null;
        while (currPortSide != lTargetPort.getSide()) {
            nextPortSide = routingDirection == EdgeRoutingDirection.CLOCKWISE ? currPortSide.right() : currPortSide.left();
            KVector currPortSideComponent = this.getBaseVector(currPortSide, slLoop.getRoutingSlot(currPortSide), routingSlotPositions);
            KVector nextPortSideComponent = this.getBaseVector(nextPortSide, slLoop.getRoutingSlot(nextPortSide), routingSlotPositions);
            if (inline && labelSide != null && lSize != null) {
                if (currPortSide == labelSide) {
                    this.adjustVectorForLabelSide(currPortSideComponent, labelSide, lSize);
                } else if (nextPortSide == labelSide) {
                    this.adjustVectorForLabelSide(nextPortSideComponent, labelSide, lSize);
                }
            }
            bendPoints.add((Object)currPortSideComponent.add(nextPortSideComponent));
            currPortSide = nextPortSide;
        }
    }

    private KVector getBaseVector(PortSide portSide, int routingSlot, double[][] routingSlotPositions) {
        double position = routingSlotPositions[portSide.ordinal()][routingSlot];
        switch (portSide) {
            case NORTH: 
            case SOUTH: {
                return new KVector(0.0, position);
            }
            case EAST: 
            case WEST: {
                return new KVector(position, 0.0);
            }
        }
        assert (false);
        return null;
    }

    private void adjustVectorForLabelSide(KVector portSideComponent, PortSide labelSide, KVector labelSize) {
        switch (labelSide) {
            case NORTH: {
                portSideComponent.y -= labelSize.y / 2.0;
                break;
            }
            case SOUTH: {
                portSideComponent.y += labelSize.y / 2.0;
                break;
            }
            case WEST: {
                portSideComponent.x -= labelSize.x / 2.0;
                break;
            }
            case EAST: {
                portSideComponent.x += labelSize.x / 2.0;
            }
        }
    }

    protected static enum EdgeRoutingDirection {
        CLOCKWISE,
        COUNTER_CLOCKWISE;

    }
}

