/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.servletoutputstream;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet.servletoutputstream.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;

public class ServletOutputStreamTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_js_servletoutputstream_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{TestServlet.class})).setWebXML(ServletOutputStreamTests.class.getResource("servlet_js_servletoutputstream_web.xml"));
    }

    @Test
    public void print_StringTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "some text");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_StringTest");
        this.invoke();
    }

    @Test
    public void print_booleanTest() throws Exception {
        String s = Boolean.TRUE.toString();
        StringBuffer ss = new StringBuffer(s).append(s);
        ((Properties)TEST_PROPS.get()).setProperty("search_string", ss.toString());
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_booleanTest");
        this.invoke();
    }

    @Test
    public void print_charTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "TEXT");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_charTest");
        this.invoke();
    }

    @Test
    public void print_doubleTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "12345.612345.6");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_doubleTest");
        this.invoke();
    }

    @Test
    public void print_floatTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "1234.51234.5");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_floatTest");
        this.invoke();
    }

    @Test
    public void print_intTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "11");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_intTest");
        this.invoke();
    }

    @Test
    public void print_longTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "12345678901234567890");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "print_longTest");
        this.invoke();
    }

    @Test
    public void printlnTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "some test");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "some test text");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "printlnTest");
        this.invoke();
    }

    @Test
    public void println_StringTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "some|text");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "sometext");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_StringTest");
        this.invoke();
    }

    @Test
    public void println_booleanTest() throws Exception {
        String s = Boolean.TRUE.toString();
        StringBuffer ss = new StringBuffer(s);
        ss = ss.append(s);
        ((Properties)TEST_PROPS.get()).setProperty("search_string", s);
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", ss.toString());
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_booleanTest");
        this.invoke();
    }

    @Test
    public void println_charTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "T|E|X|T");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "TEXT");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_charTest");
        this.invoke();
    }

    @Test
    public void println_doubleTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "12345.6");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "12345.612345.6");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_doubleTest");
        this.invoke();
    }

    @Test
    public void println_floatTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "1234.5");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "1234.51234.5");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_floatTest");
        this.invoke();
    }

    @Test
    public void println_intTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "1");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "11");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_intTest");
        this.invoke();
    }

    @Test
    public void println_longTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "1234567890");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "12345678901234567890");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "println_longTest");
        this.invoke();
    }
}

