/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.misc;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.ArrayList;
import java.util.List;

public class Client3
extends Util {
    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupOrderData")
    public void compoundSelectionGetCompoundSelectionItemsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        Expression exp1 = cbuilder.literal((Object)"1");
        Expression exp2 = cbuilder.literal((Object)"2");
        CompoundSelection cs = cbuilder.tuple(new Selection[]{exp1, exp2});
        boolean bActual = cs.isCompoundSelection();
        if (bActual) {
            List lSel = cs.getCompoundSelectionItems();
            if (lSel.size() == 2) {
                CriteriaQuery cquery = cbuilder.createTupleQuery();
                Root order = cquery.from(Order.class);
                cquery.select((Selection)cs);
                cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1"));
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List result = tquery.getResultList();
                if (result.size() == 1) {
                    int i = 0;
                    for (Tuple actual : result) {
                        pass1 = true;
                        this.logTrace("first=" + String.valueOf(actual.get(0)) + ", second=" + String.valueOf(actual.get(1)));
                        if (!actual.get(0).equals("1")) {
                            this.logErr("Expected: 1, actual:" + String.valueOf(actual.get(0)));
                            pass2 = false;
                        }
                        if (!actual.get(1).equals("2")) {
                            this.logErr("Expected: 2, actual:" + String.valueOf(actual.get(1)));
                            pass2 = false;
                        }
                        ++i;
                    }
                } else {
                    this.logErr("Expected: 1 tuple, actual:" + result.size());
                    for (Tuple actual : result) {
                        this.logErr("first=" + String.valueOf(actual.get(0)) + ", second=" + String.valueOf(actual.get(1)));
                    }
                }
            } else {
                this.logErr("Expected: 2 compound selection item, actual:" + lSel.size());
                for (Selection s : lSel) {
                    this.logErr("selection:" + s.toString());
                }
            }
        } else {
            this.logErr("Expected isCompoundSelection() to return: true, actual:" + bActual);
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("compoundSelectionGetCompoundSelectionItemsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void selectionGetCompoundSelectionItemsTest() throws Exception {
        Expression exp2;
        Expression exp1;
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CompoundSelection sel = cbuilder.tuple(new Selection[]{exp1 = cbuilder.literal((Object)"1"), exp2 = cbuilder.literal((Object)"2")});
        boolean bActual = sel.isCompoundSelection();
        if (bActual) {
            List lSel = sel.getCompoundSelectionItems();
            if (lSel.size() == 2) {
                CriteriaQuery cquery = cbuilder.createTupleQuery();
                Root order = cquery.from(Order.class);
                cquery.select((Selection)sel);
                cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1"));
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List result = tquery.getResultList();
                if (result.size() == 1) {
                    for (Tuple actual : result) {
                        pass1 = true;
                        this.logTrace("first=" + String.valueOf(actual.get(0)) + ", second=" + String.valueOf(actual.get(1)));
                        if (!actual.get(0).equals("1")) {
                            this.logErr("Expected: 1, actual:" + String.valueOf(actual.get(0)));
                            pass2 = false;
                        }
                        if (actual.get(1).equals("2")) continue;
                        this.logErr("Expected: 2, actual:" + String.valueOf(actual.get(1)));
                        pass2 = false;
                    }
                } else {
                    this.logErr("Expected: 1 tuple, actual:" + result.size());
                    for (Tuple actual : result) {
                        this.logErr("first=" + String.valueOf(actual.get(0)) + ", second=" + String.valueOf(actual.get(1)));
                    }
                }
            } else {
                this.logErr("Expected: 2 compound selection item, actual:" + lSel.size());
                for (Selection s : lSel) {
                    this.logErr("selection:" + s.toString());
                }
            }
        } else {
            this.logErr("Expected isCompoundSelection() to return: true, actual:" + bActual);
        }
        if (!pass1 || !pass2) {
            throw new Exception("selectionGetCompoundSelectionItemsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pathGetPluralAttributeTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[3].getId(), this.customerRef[13].getId()};
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.size(customer.get((PluralAttribute)Customer_.orders)), (Number)1)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("pathGetPluralAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subquery() throws Exception {
        boolean pass = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(Customer.class);
            Root sqo = sq.correlate(order);
            Join sqc = sqo.join("customer");
            sq.where((Expression)qbuilder.like((Expression)sqc.get("name"), "%Caruso")).select((Expression)sqc);
            cquery.where((Expression)qbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception subquery: ", e);
        }
        if (!pass) {
            throw new Exception("subquery failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryGroupByExpressionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            Subquery subquery = cquery.subquery(String.class);
            List gList = subquery.getGroupList();
            if (gList.size() == 0) {
                this.logTrace("Received expected empty list from getGroupList() when there is no groupBy expressions");
                pass1 = true;
            } else {
                this.logErr("Did not received empty list from getGroupList() when there is no groupBy expressions");
                for (Expression e : gList) {
                    this.logErr("Item:" + e.toString());
                }
            }
            Expression sel = subquery.getSelection();
            if (sel == null) {
                this.logTrace("Received expected null from getSelection() when there is no selection specified");
                pass2 = true;
            } else {
                this.logErr("Did not received null from getSelection() when there is no selection specified:" + sel.toString());
            }
            Root customer = subquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            subquery.select((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)));
            sel = subquery.getSelection();
            if (sel != null) {
                this.logTrace("Received non-result from getSelection()");
                pass3 = true;
            } else {
                this.logErr("Received null from getSelection() when there is a selection specified");
            }
            subquery.where((Expression)qbuilder.like((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), "%Caruso"));
            Path exp = customer.get(Customer_2.getSingularAttribute("name", String.class));
            subquery.groupBy(new Expression[]{exp});
            gList = subquery.getGroupList();
            if (gList != null) {
                this.logTrace("Received non-null from getGroupList() when there is groupBy expressions");
                if (gList.size() == 1) {
                    this.logTrace("Received one groupBy expression");
                    pass4 = true;
                } else {
                    this.logErr("Expected one groupBy expression, actual:" + gList.size());
                    for (Expression e : gList) {
                        this.logErr("Did not get expected result:" + String.valueOf(e));
                    }
                }
            } else {
                this.logErr("Received null from getGroupList() when there is groupBy expressions");
            }
            cquery.where((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("name", String.class)).in(new Expression[]{subquery}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass5 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("subqueryGroupByExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryGroupByExpressionArrayTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            Subquery subquery = cquery.subquery(String.class);
            Root customer = subquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            subquery.select((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)));
            subquery.where((Expression)qbuilder.like((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), "%Caruso"));
            Expression[] exp = new Expression[]{customer.get(Customer_2.getSingularAttribute("id", String.class))};
            subquery.groupBy(exp);
            cquery.where((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("id", String.class)).in(new Expression[]{subquery}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception subquery: ", e);
        }
        if (!pass) {
            throw new Exception("subqueryGroupByExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryGroupByListTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            Subquery subquery = cquery.subquery(String.class);
            Root customer = subquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            subquery.select((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)));
            subquery.where((Expression)qbuilder.like((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), "%Caruso"));
            ArrayList<Path> list = new ArrayList<Path>();
            list.add(customer.get(Customer_2.getSingularAttribute("id", String.class)));
            subquery.groupBy(list);
            cquery.where((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("id", String.class)).in(new Expression[]{subquery}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception subquery: ", e);
        }
        if (!pass) {
            throw new Exception("subqueryGroupByListTest failed");
        }
    }
}

