/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.FilterRegistration;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.FilterRegistrationImpl;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;

public class DynamicFilterRegistrationImpl
extends FilterRegistrationImpl
implements FilterRegistration.Dynamic {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    public DynamicFilterRegistrationImpl(FilterDef filterDef, StandardContext ctx) {
        super(filterDef, ctx);
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00115"), "async-supported", this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.filterDef.setIsAsyncSupported(isAsyncSupported);
    }
}

