/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.AppTenant;
import com.sun.enterprise.config.serverbeans.AppTenants;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.ReadableArchiveScannerAdapter;
import com.sun.enterprise.v3.server.SnifferManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.virtualization.VirtualizationEnv;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.ClientJarWriter;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.monitor.DeploymentLifecycleProbeProvider;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.util.CommonModelRegistry;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.ApplicationLifecycleInterceptor;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class ApplicationLifecycle
implements Deployment,
PostConstruct {
    private static final String[] UPLOADED_GENERATED_DIRS = new String[]{"policy", "xml", "ejb", "jsp"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    private static final Logger LOG = KernelLoggerInfo.getLogger();
    @Inject
    private SnifferManagerImpl snifferManager;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private ContainerRegistry containerRegistry;
    @Inject
    private ApplicationRegistry appRegistry;
    @Inject
    private Applications applications;
    @Inject
    @Named(value="default-instance-name")
    private Server server;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject
    @Optional
    private VirtualizationEnv virtEnv;
    @Inject
    private Events events;
    private DeploymentLifecycleProbeProvider deploymentLifecycleProbeProvider;
    private ExecutorService executorService;
    private Collection<ApplicationLifecycleInterceptor> alcInterceptors = Collections.emptyList();
    private ThreadLocal<Deque<ExtendedDeploymentContext>> currentDeploymentContext;

    protected Deployer<?, ?> getDeployer(EngineInfo engineInfo) {
        return engineInfo.getDeployer();
    }

    public void postConstruct() {
        this.executorService = this.createExecutorService();
        this.deploymentLifecycleProbeProvider = new DeploymentLifecycleProbeProvider();
        this.alcInterceptors = this.serviceLocator.getAllServices(ApplicationLifecycleInterceptor.class, new Annotation[0]);
        this.currentDeploymentContext = new ThreadLocal();
    }

    public DeploymentContext getCurrentDeploymentContext() {
        Deque<ExtendedDeploymentContext> current = this.currentDeploymentContext.get();
        return current == null ? null : (DeploymentContext)current.peek();
    }

    private void pushCurrentDeploymentContext(ExtendedDeploymentContext context) {
        Deque<ExtendedDeploymentContext> current = this.currentDeploymentContext.get();
        if (current == null) {
            current = new LinkedList<ExtendedDeploymentContext>();
            this.currentDeploymentContext.set(current);
        }
        current.push(context);
    }

    private ExtendedDeploymentContext popCurrentDeploymentContext() {
        Deque<ExtendedDeploymentContext> current = this.currentDeploymentContext.get();
        ExtendedDeploymentContext context = current.pop();
        if (current.isEmpty()) {
            this.currentDeploymentContext.remove();
        }
        return context;
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        return this.getArchiveHandler(archive, null);
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive, String type) throws IOException {
        if (type != null) {
            return ((ArchiveDetector)this.serviceLocator.getService(ArchiveDetector.class, type, new Annotation[0])).getArchiveHandler();
        }
        ArrayList detectors = new ArrayList(this.serviceLocator.getAllServices(ArchiveDetector.class, new Annotation[0]));
        Collections.sort(detectors, new Comparator<ArchiveDetector>(this){

            @Override
            public int compare(ArchiveDetector o1, ArchiveDetector o2) {
                return o1.rank() - o2.rank();
            }
        });
        for (ArchiveDetector detector : detectors) {
            if (!detector.handles(archive)) continue;
            return detector.getArchiveHandler();
        }
        return null;
    }

    public ApplicationInfo deploy(ExtendedDeploymentContext context) {
        return this.deploy(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationInfo deploy(Collection<? extends Sniffer> sniffers, final ExtendedDeploymentContext context) {
        operationStartTime = Calendar.getInstance().getTimeInMillis();
        this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_START, (Object)context), false);
        report = context.getActionReport();
        commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        appName = commandParams.name();
        if (commandParams.origin == OpsParams.Origin.deploy && this.appRegistry.get(appName) != null) {
            report.setMessage(ApplicationLifecycle.localStrings.getLocalString("appnamenotunique", "Application name {0} is already in use. Please pick a different name.", new Object[]{appName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        if (commandParams.virtualservers == null) {
            commandParams.virtualservers = DeploymentUtils.getVirtualServers((String)commandParams.target, (ServerEnvironment)this.env, (Domain)this.domain);
        }
        if (commandParams.enabled == null) {
            commandParams.enabled = true;
        }
        if (commandParams.altdd != null) {
            context.getSource().addArchiveMetaData("altdd", (Object)commandParams.altdd);
        }
        if (commandParams.runtimealtdd != null) {
            context.getSource().addArchiveMetaData("runtimealtdd", (Object)commandParams.runtimealtdd);
        }
        tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                for (EngineRef module : this.get("loaded", EngineRef.class)) {
                    try {
                        module.stop((ApplicationContext)context);
                    }
                    catch (Exception exception) {}
                }
                try {
                    ((PreDestroy)PreDestroy.class.cast(context)).preDestroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (EngineRef module : this.get("loaded", EngineRef.class)) {
                    try {
                        module.unload(context);
                    }
                    catch (Exception exception) {}
                }
                try {
                    ApplicationInfo appInfo = ApplicationLifecycle.this.appRegistry.get(appName);
                    if (appInfo != null) {
                        ApplicationLifecycle.this.unload(appInfo, context);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (EngineRef module : this.get("prepared", EngineRef.class)) {
                    try {
                        module.clean(context);
                    }
                    catch (Exception exception) {}
                }
                if (!commandParams.keepfailedstubs.booleanValue()) {
                    try {
                        context.clean();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ApplicationLifecycle.this.appRegistry.remove(appName);
            }
        };
        context.addTransientAppMetaData("tracker", (Object)tracker);
        context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
        appInfo = null;
        this.pushCurrentDeploymentContext(context);
        handler = context.getArchiveHandler();
        if (handler == null) {
            handler = this.getArchiveHandler(context.getSource(), commandParams.type);
            context.setArchiveHandler(handler);
        }
        if (handler == null) {
            report.setMessage(ApplicationLifecycle.localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{context.getSourceDir()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            var11_11 = null;
            this.popCurrentDeploymentContext();
        }
        ** GOTO lbl51
        {
            catch (Throwable e) {
                report.failure(ApplicationLifecycle.LOG, ApplicationLifecycle.localStrings.getLocalString("error.deploying.app", "Exception while deploying the app [{0}]", new Object[]{appName}), null);
                report.setFailureCause(e);
                ApplicationLifecycle.LOG.log(Level.SEVERE, "NCLS-CORE-00026", e);
                tracker.actOn(ApplicationLifecycle.LOG);
                return null;
            }
            catch (Throwable var23_34) {
                throw var23_34;
            }
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                if (appInfo == null) return var11_11;
                this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                return var11_11;
            }
            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
            return var11_11;
lbl51:
            // 1 sources

            tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.ARCHIVE_HANDLER_OBTAINED);
            }
            if (handler.requiresAnnotationScanning(context.getSource())) {
                this.getDeployableTypes((DeploymentContext)context);
            }
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.PARSING_DONE);
            }
            if (sniffers != null && ApplicationLifecycle.LOG.isLoggable(Level.FINE)) {
                ApplicationLifecycle.LOG.log(Level.FINE, "Before Sorting: " + sniffers.stream().map((Function<Sniffer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getModuleType(), (Lorg/glassfish/api/container/Sniffer;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
            }
            sniffers = this.getSniffers(handler, sniffers, (DeploymentContext)context);
            classLoaderHierarchy = (ClassLoaderHierarchy)this.serviceLocator.getService(ClassLoaderHierarchy.class, new Annotation[0]);
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.CLASS_LOADER_HIERARCHY);
            }
            context.createDeploymentClassLoader(classLoaderHierarchy, handler);
            this.events.send(new EventListener.Event(ApplicationLifecycle.AFTER_DEPLOYMENT_CLASSLOADER_CREATION, (Object)context), false);
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.CLASS_LOADER_CREATED);
            }
            cloader = context.getClassLoader();
            currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(cloader);
                sortedEngineInfos = this.setupContainerInfos(handler, sniffers, (DeploymentContext)context);
                if (tracing != null) {
                    tracing.addMark(DeploymentTracing.Mark.CONTAINERS_SETUP_DONE);
                }
                if (ApplicationLifecycle.LOG.isLoggable(Level.FINE)) {
                    ApplicationLifecycle.LOG.log(Level.FINE, "After Sorting: " + sortedEngineInfos.stream().map((Function<EngineInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$deploy$0(org.glassfish.internal.data.EngineInfo ), (Lorg/glassfish/internal/data/EngineInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
                }
                if (Utility.isEmpty(sortedEngineInfos)) {
                    report.failure(ApplicationLifecycle.LOG, ApplicationLifecycle.localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource().getName()}));
                    tracker.actOn(ApplicationLifecycle.LOG);
                    var16_19 = null;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var22_33) {}
            {
                context.postDeployClean(false);
                Thread.currentThread().setContextClassLoader(currentCL);
                throw var22_33;
            }
        }
        context.postDeployClean(false);
        Thread.currentThread().setContextClassLoader(currentCL);
        this.popCurrentDeploymentContext();
        if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, appInfo));
            operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
            if (appInfo == null) return var16_19;
            this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
            return var16_19;
        }
        this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
        return var16_19;
lbl-1000:
        // 1 sources

        {
            tempAppInfo = new ApplicationInfo(this.events, context.getSource(), appName);
            for (E m : context.getModuleMetadata()) {
                tempAppInfo.addMetaData(m);
            }
            tempAppInfo.detectIfJakartaEEApp(sortedEngineInfos);
            context.getSource().setExtraData(Boolean.class, (Object)tempAppInfo.isJakartaEEApp());
            this.appRegistry.add(appName, tempAppInfo);
            try {
                this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.PREPARE, context);
            }
            catch (Throwable interceptorException) {
                report.failure(ApplicationLifecycle.LOG, "Exception while invoking the lifecycle interceptor", null);
                report.setFailureCause(interceptorException);
                ApplicationLifecycle.LOG.log(Level.SEVERE, "NCLS-CORE-00026", interceptorException);
                tracker.actOn(ApplicationLifecycle.LOG);
                m = null;
                context.postDeployClean(false);
                Thread.currentThread().setContextClassLoader(currentCL);
                this.popCurrentDeploymentContext();
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                    if (appInfo == null) return m;
                    this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                    return m;
                }
                this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                return m;
            }
        }
        {
            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION, (Object)context), false);
            context.createApplicationClassLoader(classLoaderHierarchy, handler);
            this.events.send(new EventListener.Event(Deployment.AFTER_APPLICATION_CLASSLOADER_CREATION, (Object)context), false);
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.CLASS_LOADER_CREATED);
            }
            moduleInfo = null;
            try {
                moduleInfo = this.prepareModule(sortedEngineInfos, appName, (DeploymentContext)context, tracker);
                cjw = new ClientJarWriter(context);
                cjw.run();
            }
            catch (Throwable prepareException) {
                prepareException.printStackTrace();
                report.failure(ApplicationLifecycle.LOG, "Exception while preparing the app", null);
                report.setFailureCause(prepareException);
                ApplicationLifecycle.LOG.log(Level.SEVERE, "NCLS-CORE-00026", prepareException);
                tracker.actOn(ApplicationLifecycle.LOG);
                operationTime = null;
                context.postDeployClean(false);
                Thread.currentThread().setContextClassLoader(currentCL);
                this.popCurrentDeploymentContext();
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
                    operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                    if (appInfo == null) return operationTime;
                    this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                    return operationTime;
                }
                this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                return operationTime;
            }
        }
        {
            appInfo = (ApplicationInfo)context.getModuleMetaData(ApplicationInfo.class);
            if (appInfo == null) {
                appInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                context.addModuleMetaData((Object)appInfo);
                appInfo.addModule(moduleInfo);
                for (E m : context.getModuleMetadata()) {
                    moduleInfo.addMetaData(m);
                    appInfo.addMetaData(m);
                }
            } else {
                for (EngineRef ref : moduleInfo.getEngineRefs()) {
                    appInfo.add(ref);
                }
            }
            this.appRegistry.remove(appName);
            appInfo.detectIfJakartaEEApp(sortedEngineInfos);
            this.appRegistry.add(appName, appInfo);
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.PREPARE, context);
            if (tracing != null) {
                tracing.addMark(DeploymentTracing.Mark.PREPARED);
            }
            context.setPhase(ExtendedDeploymentContext.Phase.PREPARED);
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            appInfo.setAppClassLoader(context.getClassLoader());
            this.events.send(new EventListener.Event(Deployment.APPLICATION_PREPARED, (Object)context), false);
            if (!this.loadOnCurrentInstance((DeploymentContext)context)) ** GOTO lbl-1000
            appInfo.setLibraries(commandParams.libraries());
            try {
                this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.LOAD, context);
                appInfo.load(context, tracker);
                this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.LOAD, context);
                this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.START, context);
                appInfo.start(context, tracker);
                this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.START, context);
            }
            catch (Throwable loadException) {
                ApplicationLifecycle.LOG.log(Level.SEVERE, "NCLS-CORE-00026", loadException);
                report.failure(ApplicationLifecycle.LOG, "Exception while loading the app", null);
                report.setFailureCause(loadException);
                tracker.actOn(ApplicationLifecycle.LOG);
                ref = null;
                context.postDeployClean(false);
                Thread.currentThread().setContextClassLoader(currentCL);
                this.popCurrentDeploymentContext();
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
                    operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                    if (appInfo == null) return ref;
                    this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                    return ref;
                }
                this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                return ref;
            }
        }
lbl-1000:
        // 2 sources

        {
            var18_24 = appInfo;
        }
        context.postDeployClean(false);
        Thread.currentThread().setContextClassLoader(currentCL);
        this.popCurrentDeploymentContext();
        if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
            operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
            if (appInfo == null) return var18_24;
            this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
            return var18_24;
        }
        this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
        return var18_24;
    }

    public Types getDeployableTypes(DeploymentContext context) throws IOException {
        DeploymentContext deploymentContext = context;
        synchronized (deploymentContext) {
            Types types = (Types)context.getTransientAppMetaData(Types.class.getName(), Types.class);
            if (types != null) {
                return types;
            }
            try {
                Parser parser = new Parser(new ParsingContext.Builder().logger(context.getLogger()).executorService(this.executorService).locator(this.getResourceLocator()).build());
                try (ReadableArchiveScannerAdapter scannerAdapter = new ReadableArchiveScannerAdapter(parser, context.getSource());){
                    parser.parse((ArchiveAdapter)scannerAdapter, null);
                    List<ReadableArchive> externalLibraries = this.getExternalLibraries(context);
                    for (ReadableArchive externalLibrary : externalLibraries) {
                        parser.parse((ArchiveAdapter)new ReadableArchiveScannerAdapter(parser, externalLibrary), null);
                    }
                    parser.awaitTermination();
                    for (ReadableArchive externalLibrary : externalLibraries) {
                        externalLibrary.close();
                    }
                }
                context.addTransientAppMetaData(Types.class.getName(), (Object)parser.getContext().getTypes());
                context.addTransientAppMetaData(Parser.class.getName(), (Object)parser);
                return parser.getContext().getTypes();
            }
            catch (InterruptedException | URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }

    private ResourceLocator getResourceLocator() {
        if (CommonModelRegistry.getInstance().canLoadResources()) {
            return null;
        }
        final ClassLoader classLoader = ((ClassLoaderHierarchy)this.serviceLocator.getService(ClassLoaderHierarchy.class, new Annotation[0])).getCommonClassLoader();
        return new ResourceLocator(){

            private boolean excluded(String name) {
                return name.startsWith("java/") || name.startsWith("sun/") || name.startsWith("com/sun/");
            }

            public InputStream openResourceStream(String name) throws IOException {
                return this.excluded(name) ? null : classLoader.getResourceAsStream(name);
            }

            public URL getResource(String name) {
                return this.excluded(name) ? null : classLoader.getResource(name);
            }
        };
    }

    private void notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext dc) {
        for (ApplicationLifecycleInterceptor interceptor : this.alcInterceptors) {
            interceptor.before(phase, dc);
        }
    }

    private void notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext dc) {
        for (ApplicationLifecycleInterceptor interceptor : this.alcInterceptors) {
            interceptor.after(phase, dc);
        }
    }

    private List<ReadableArchive> getExternalLibraries(DeploymentContext context) throws IOException, URISyntaxException {
        ArrayList<ReadableArchive> externalLibArchives = new ArrayList<ReadableArchive>();
        String skipScanExternalLibProp = context.getAppProps().getProperty("skipScanExternalLib");
        if (Boolean.parseBoolean(skipScanExternalLibProp)) {
            return Collections.emptyList();
        }
        for (URI externalLib : DeploymentUtils.getExternalLibraries((ReadableArchive)context.getSource())) {
            externalLibArchives.add(this.archiveFactory.openArchive(new File(externalLib.getPath())));
        }
        for (URI externalLib : context.getAppLibs()) {
            externalLibArchives.add(this.archiveFactory.openArchive(new File(externalLib.getPath())));
        }
        return externalLibArchives;
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(LOG);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(LOG);
        }
        return isSuccess;
    }

    public List<EngineInfo<?, ?>> setupContainerInfos(DeploymentContext context) throws Exception {
        return this.setupContainerInfos(context.getArchiveHandler(), this.getSniffers(context.getArchiveHandler(), null, context), context);
    }

    public Collection<? extends Sniffer> getSniffers(ArchiveHandler handler, Collection<? extends Sniffer> sniffers, DeploymentContext context) {
        if (handler == null) {
            return Collections.emptyList();
        }
        if (sniffers == null) {
            if (handler instanceof CompositeHandler) {
                ((CompositeHandler)handler).initCompositeMetaData(context);
                context.getAppProps().setProperty("isComposite", "true");
            }
            sniffers = this.snifferManager.getSniffers(context);
        }
        context.addTransientAppMetaData("sniffers", sniffers);
        this.snifferManager.validateSniffers(sniffers, context);
        return sniffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EngineInfo<?, ?>> setupContainerInfos(ArchiveHandler handler, Collection<? extends Sniffer> sniffers, DeploymentContext context) throws Exception {
        ActionReport report = context.getActionReport();
        DeploymentTracing tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
        LinkedHashMap<Deployer, EngineInfo> containerInfosByDeployers = new LinkedHashMap<Deployer, EngineInfo>();
        for (Sniffer sniffer : sniffers) {
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(LOG, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            String[] containerNames = sniffer.getContainersNames();
            this.traceContainers(tracing, containerNames, DeploymentTracing.ContainerMark.SNIFFER_DONE);
            if (this.areSomeContainersNotStarted(containerNames)) {
                Collection<EngineInfo<?, ?>> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.areSomeContainersNotStarted(containerNames)) {
                        this.traceContainers(tracing, containerNames, DeploymentTracing.ContainerMark.BEFORE_CONTAINER_SETUP);
                        containersInfo = this.setupContainer(sniffer, LOG, context);
                        this.traceContainers(tracing, containerNames, DeploymentTracing.ContainerMark.AFTER_CONTAINER_SETUP);
                        if (Utility.isEmpty(containersInfo)) {
                            String string = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                            report.failure(LOG, string, null);
                            throw new Exception(string);
                        }
                    }
                }
                if (containersInfo != null && !this.startContainers(containersInfo, LOG, context)) {
                    String msg = "Aborting, Failed to start containers for sniffer " + sniffer.getModuleType();
                    report.failure(LOG, msg, null);
                    throw new Exception(msg);
                }
            }
            for (Object object : containerNames) {
                EngineInfo engineInfo = this.containerRegistry.getContainer((String)object);
                this.traceContainer(tracing, (String)object, DeploymentTracing.ContainerMark.GOT_CONTAINER);
                if (engineInfo == null) {
                    String msg = "Aborting, Failed to start container " + (String)object + " for sinffer " + sniffer.getModuleType();
                    report.failure(LOG, msg, null);
                    throw new Exception(msg);
                }
                Deployer<?, ?> deployer = this.getDeployer(engineInfo);
                if (deployer == null) {
                    if (!this.startContainers(Collections.singleton(engineInfo), LOG, context)) {
                        String msg = "Aborting, Failed to start container " + (String)object + " for sniffer " + sniffer.getModuleType();
                        report.failure(LOG, msg, null);
                        throw new Exception(msg);
                    }
                    deployer = this.getDeployer(engineInfo);
                    if (deployer == null) {
                        String msg = "Got a null deployer out of the " + String.valueOf(engineInfo.getContainer().getClass()) + " container, is it annotated with @Service ?";
                        report.failure(LOG, msg);
                        throw new Exception(msg);
                    }
                }
                this.traceContainer(tracing, (String)object, DeploymentTracing.ContainerMark.GOT_DEPLOYER);
                containerInfosByDeployers.put(deployer, engineInfo);
            }
        }
        ArrayList sortedEngineInfos = new ArrayList();
        HashMap hashMap = new HashMap();
        for (Object provider : this.serviceLocator.getAllServices(ApplicationMetaDataProvider.class, new Annotation[0])) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                hashMap.put(provided, (ApplicationMetaDataProvider<?>)provider);
            }
        }
        for (Object provider : this.serviceLocator.getAllServices(ApplicationMetaDataProvider.class, new Annotation[0])) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (hashMap.containsKey(dependency)) continue;
                LOG.log(Level.WARNING, "NCLS-CORE-00027", new Object[]{provider, dependency});
            }
        }
        HashMap typeByDeployer = new HashMap();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        this.logMessageIfRequiredDependenciesNotAvailable(containerInfosByDeployers, typeByDeployer, hashMap);
        ArrayList orderedDeployers = new ArrayList();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            LOG.log(Level.FINE, "Keyed Deployer {0}", deployer.getClass());
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, hashMap, context);
        }
        for (Deployer deployer : orderedDeployers) {
            LOG.log(Level.FINE, "Ordered Deployer {0}", deployer);
            MetaData metaData = deployer.getMetaData();
            try {
                if (metaData == null) {
                    deployer.loadMetaData(null, context);
                } else {
                    Object[] provides = metaData.provides();
                    if (Utility.isEmpty((Object[])provides)) {
                        deployer.loadMetaData(null, context);
                    } else {
                        for (Object provide : provides) {
                            Object contextMetaData = context.getModuleMetaData((Class)provide);
                            if (contextMetaData == null) {
                                context.addModuleMetaData(deployer.loadMetaData((Class)provide, context));
                                continue;
                            }
                            deployer.loadMetaData(null, context);
                        }
                    }
                }
            }
            catch (Exception e) {
                report.failure(LOG, "Exception while invoking " + String.valueOf(deployer.getClass()) + " prepare method", (Throwable)e);
                throw e;
            }
            sortedEngineInfos.add((EngineInfo)containerInfosByDeployers.get(deployer));
        }
        return sortedEngineInfos;
    }

    private void logMessageIfRequiredDependenciesNotAvailable(Map<Deployer, EngineInfo> containerInfosByDeployers, Map<Class<?>, Deployer<?, ?>> typeByDeployer, Map<Class<?>, ApplicationMetaDataProvider<?>> typeByProvider) {
        if (LOG.isLoggable(Level.FINE)) {
            for (Deployer deployer : containerInfosByDeployers.keySet()) {
                if (deployer.getMetaData() == null) continue;
                for (Class dependency : deployer.getMetaData().requires()) {
                    if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                    Service s = deployer.getClass().getAnnotation(Service.class);
                    String serviceName = s != null && s.name() != null && s.name().length() > 0 ? s.name() : deployer.getClass().getSimpleName();
                    LOG.fine(() -> serviceName + " deployer requires " + String.valueOf(dependency) + " but no other deployer provides it");
                }
            }
        }
    }

    private boolean areSomeContainersNotStarted(String[] containerNames) {
        for (String containerName : containerNames) {
            if (this.containerRegistry.getContainer(containerName) != null) continue;
            return true;
        }
        return false;
    }

    private void loadDeployer(List<Deployer<?, ?>> results, Deployer<?, ?> deployer, Map<Class<?>, Deployer<?, ?>> typeByDeployer, Map<Class<?>, ApplicationMetaDataProvider<?>> typeByProvider, DeploymentContext dc) throws IOException {
        if (results.contains(deployer)) {
            return;
        }
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (dc.getModuleMetaData(required) != null) continue;
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider<?> provider = typeByProvider.get(required);
                if (provider == null) {
                    LOG.log(Level.FINE, () -> "Nothing is providing " + String.valueOf(required) + ", this should be treated as an optional dependancy");
                    continue;
                }
                LinkedList providers = new LinkedList();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider applicationMetaDataProvider : providers) {
                    dc.addModuleMetaData(applicationMetaDataProvider.load(dc));
                }
            }
        }
        results.add(deployer);
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider<?>> results, Map<Class<?>, ApplicationMetaDataProvider<?>> providers, ApplicationMetaDataProvider<?> provider) {
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
        results.addFirst(provider);
    }

    public ModuleInfo prepareModule(List<EngineInfo<?, ?>> sortedEngineInfos, String moduleName, DeploymentContext context, ProgressTracker tracker) throws Exception {
        String isComposite;
        ActionReport report = context.getActionReport();
        ArrayList<EngineRef> addedEngines = new ArrayList<EngineRef>();
        DeploymentTracing tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addModuleMark(DeploymentTracing.ModuleMark.PREPARE, moduleName);
        }
        for (EngineInfo<?, ?> engineInfo : sortedEngineInfos) {
            Deployer deployer = engineInfo.getDeployer();
            try {
                this.traceContainer(tracing, engineInfo.getSniffer().getModuleType(), DeploymentTracing.ContainerMark.PREPARE);
                deployer.prepare(context);
                this.traceContainer(tracing, engineInfo.getSniffer().getModuleType(), DeploymentTracing.ContainerMark.PREPARED);
                EngineRef engineRef = new EngineRef(engineInfo, null);
                addedEngines.add(engineRef);
                tracker.add("prepared", EngineRef.class, (Object)engineRef);
                tracker.add(Deployer.class, (Object)deployer);
            }
            catch (Exception e) {
                report.failure(LOG, "Exception while invoking " + String.valueOf(deployer.getClass()) + " prepare method", (Throwable)e);
                throw e;
            }
        }
        if (tracing != null) {
            tracing.addModuleMark(DeploymentTracing.ModuleMark.PREPARE_EVENTS, moduleName);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_PREPARED, (Object)context), false);
        }
        if (tracing != null) {
            tracing.addModuleMark(DeploymentTracing.ModuleMark.PREPARED, moduleName);
        }
        if ((isComposite = context.getAppProps().getProperty("isComposite")) != null) {
            context.getModuleProps().setProperty("isComposite", isComposite);
        }
        ModuleInfo mi = new ModuleInfo(this.events, moduleName, addedEngines, context.getModuleProps());
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(context.getAppProps());
        for (EngineRef er : mi.getEngineRefs()) {
            ApplicationConfig c = savedAppConfig.get(mi.getName(), er.getContainerInfo().getSniffer().getModuleType());
            if (c == null) continue;
            er.setApplicationConfig(c);
        }
        return mi;
    }

    protected Collection<EngineInfo<?, ?>> setupContainer(Sniffer sniffer, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        ContainerStarter starter = (ContainerStarter)this.serviceLocator.getService(ContainerStarter.class, new Annotation[0]);
        Collection<EngineInfo<?, ?>> containersInfo = starter.startContainer(sniffer);
        if (Utility.isEmpty(containersInfo)) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<EngineInfo<?, ?>> containersInfo, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        for (EngineInfo<?, ?> engineInfo : containersInfo) {
            Container container;
            try {
                container = engineInfo.getContainer();
            }
            catch (Exception e) {
                LogRecord log = new LogRecord(Level.SEVERE, "NCLS-CORE-00029");
                log.setParameters(new Object[]{engineInfo.getSniffer().getModuleType()});
                log.setThrown(e);
                LOG.log(log);
                return false;
            }
            Class deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.serviceLocator.getService(deployerClass, new Annotation[0]);
                engineInfo.setDeployer(deployer);
            }
            catch (MultiException e) {
                report.failure(logger, "Cannot instantiate or inject " + String.valueOf(deployerClass), (Throwable)e);
                engineInfo.stop(logger);
                return false;
            }
            catch (ClassCastException e) {
                engineInfo.stop(logger);
                report.failure(logger, String.valueOf(deployerClass) + " does not implement  the org.jvnet.glassfish.api.deployment.Deployer interface", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(EngineInfo<?, ?>[] ctrInfos, Logger logger) {
        for (EngineInfo<?, ?> ctrInfo : ctrInfos) {
            try {
                ctrInfo.stop(logger);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "NCLS-CORE-00030", new Object[]{ctrInfo.getSniffer().getModuleType(), e});
            }
        }
    }

    public ApplicationInfo unload(ApplicationInfo info, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        if (info == null) {
            report.failure(context.getLogger(), "Application not registered", null);
            return null;
        }
        this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.STOP, context);
        if (info.isLoaded()) {
            info.stop(context, context.getLogger());
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.STOP, context);
            this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.UNLOAD, context);
            info.unload(context);
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.UNLOAD, context);
        }
        this.events.send(new EventListener.Event(Deployment.APPLICATION_DISABLED, (Object)info), false);
        try {
            this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.CLEAN, context);
            info.clean(context);
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.CLEAN, context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while cleaning", (Throwable)e);
            return info;
        }
        return info;
    }

    public void undeploy(String appName, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        UndeployCommandParameters params = (UndeployCommandParameters)context.getCommandParameters(UndeployCommandParameters.class);
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_FAILURE, (Object)context));
            return;
        }
        this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_START, (Object)info));
        if (DeploymentUtils.isDASTarget((String)params.target)) {
            this.unload(info, context);
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_SUCCESS, (Object)context));
            this.deploymentLifecycleProbeProvider.applicationUndeployedEvent(appName, this.getApplicationType(info));
        } else {
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_FAILURE, (Object)context));
        }
        this.appRegistry.remove(appName);
    }

    public Transaction prepareAppConfigChanges(DeploymentContext context) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        Transaction t = new Transaction();
        try {
            ConfigBean newBean = ((ConfigBean)Dom.unwrap((ConfigBeanProxy)this.applications)).allocate(Application.class);
            Application app = (Application)newBean.createProxy();
            Application app_w = (Application)t.enroll((ConfigBeanProxy)app);
            this.setInitialAppAttributes(app_w, deployParams, appProps, context);
            context.addTransientAppMetaData("application", (Object)app_w);
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw e;
        }
        catch (Exception e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        return t;
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t) throws TransactionFailure {
        this.registerAppInDomainXML(applicationInfo, context, t, false);
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t, boolean appRefOnly) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        if (t != null) {
            try {
                if (!appRefOnly) {
                    Application app_w = (Application)context.getTransientAppMetaData("application", Application.class);
                    this.setRestAppAttributes(app_w, appProps);
                    Applications apps_w = (Applications)t.enroll((ConfigBeanProxy)this.applications);
                    apps_w.getModules().add(app_w);
                    if (applicationInfo != null) {
                        applicationInfo.save(app_w);
                    }
                }
                List targets = new ArrayList<String>();
                if (!DeploymentUtils.isDomainTarget((String)deployParams.target)) {
                    targets.add(deployParams.target);
                } else {
                    List previousTargets = (List)context.getTransientAppMetaData("previousTargets", List.class);
                    if (previousTargets == null) {
                        previousTargets = this.domain.getAllReferencedTargetsForApplication(deployParams.name);
                    }
                    targets = previousTargets;
                }
                String origVS = deployParams.virtualservers;
                Boolean origEnabled = deployParams.enabled;
                Properties previousVirtualServers = (Properties)context.getTransientAppMetaData("previousVirtualServers", Properties.class);
                Properties previousEnabledAttributes = (Properties)context.getTransientAppMetaData("previousEnabledAttributes", Properties.class);
                for (String target : targets) {
                    Cluster cluster;
                    Server servr;
                    deployParams.virtualservers = origVS;
                    deployParams.enabled = origEnabled;
                    if (DeploymentUtils.isDomainTarget((String)deployParams.target)) {
                        String enabledAttr;
                        String vs = previousVirtualServers.getProperty(target);
                        if (vs != null) {
                            deployParams.virtualservers = vs;
                        }
                        if ((enabledAttr = previousEnabledAttributes.getProperty(target)) != null) {
                            deployParams.enabled = Boolean.valueOf(enabledAttr);
                        }
                    }
                    if (deployParams.enabled == null) {
                        deployParams.enabled = Boolean.TRUE;
                    }
                    if ((servr = this.domain.getServerNamed(target)) != null) {
                        ConfigBeanProxy servr_w = t.enroll((ConfigBeanProxy)servr);
                        ApplicationRef appRef = (ApplicationRef)servr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef, deployParams);
                        ((Server)servr_w).getApplicationRef().add(appRef);
                    }
                    if ((cluster = this.domain.getClusterNamed(target)) == null) continue;
                    ConfigBeanProxy cluster_w = t.enroll((ConfigBeanProxy)cluster);
                    ApplicationRef appRef = (ApplicationRef)cluster_w.createChild(ApplicationRef.class);
                    this.setAppRefAttributes(appRef, deployParams);
                    ((Cluster)cluster_w).getApplicationRef().add(appRef);
                    for (Server svr : cluster.getInstances()) {
                        ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                        ApplicationRef appRef2 = (ApplicationRef)svr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef2, deployParams);
                        ((Server)svr_w).getApplicationRef().add(appRef2);
                    }
                }
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
            catch (Exception e) {
                t.rollback();
                throw new TransactionFailure(e.getMessage(), (Throwable)e);
            }
            try {
                t.commit();
            }
            catch (RetryableException e) {
                LOG.log(Level.INFO, "Rollbacking the transaction. Retryable...");
                LOG.log(Level.FINEST, "Rollbacking the transaction.", e);
                t.rollback();
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
        }
    }

    public void registerTenantWithAppInDomainXML(String appName, ExtendedDeploymentContext context) throws TransactionFailure {
        Transaction t = new Transaction();
        try {
            AppTenant appTenant_w = this.writeableTenantForApp(appName, t);
            appTenant_w.setContextRoot(context.getAppProps().getProperty("context-root"));
            appTenant_w.setTenant(context.getTenant());
            t.commit();
        }
        catch (TransactionFailure ex) {
            t.rollback();
            throw ex;
        }
        catch (Throwable ex) {
            t.rollback();
            throw new TransactionFailure(ex.getLocalizedMessage(), ex);
        }
    }

    public void unregisterTenantWithAppInDomainXML(String appName, String tenantName) throws TransactionFailure, RetryableException {
        Application app = this.applications.getApplication(appName);
        if (app == null) {
            throw new IllegalArgumentException("Application " + appName + " not found");
        }
        AppTenants appTenants = app.getAppTenants();
        AppTenant appTenant = appTenants.getAppTenant(tenantName);
        if (appTenant == null) {
            throw new IllegalArgumentException("Tenant " + tenantName + " not provisioned for application " + appName);
        }
        Transaction t = new Transaction();
        AppTenants appTenants_w = (AppTenants)t.enroll((ConfigBeanProxy)appTenants);
        appTenants_w.getAppTenant().remove(appTenant);
        t.commit();
    }

    private AppTenant writeableTenantForApp(String appName, Transaction t) throws TransactionFailure, PropertyVetoException {
        AppTenants appTenants_w;
        Application app = this.applications.getApplication(appName);
        if (app == null) {
            throw new IllegalArgumentException("Application " + appName + " not found");
        }
        AppTenants appTenants = app.getAppTenants();
        if (appTenants == null) {
            Application app_w = (Application)t.enroll((ConfigBeanProxy)app);
            appTenants_w = (AppTenants)app_w.createChild(AppTenants.class);
            app_w.setAppTenants(appTenants_w);
        } else {
            appTenants_w = (AppTenants)t.enroll((ConfigBeanProxy)appTenants);
        }
        List appTenantList = appTenants_w.getAppTenant();
        AppTenant appTenant_w = (AppTenant)appTenants_w.createChild(AppTenant.class);
        appTenantList.add(appTenant_w);
        return appTenant_w;
    }

    private void setInitialAppAttributes(Application app, DeployCommandParameters deployParams, Properties appProps, DeploymentContext context) throws PropertyVetoException {
        Properties previousEnabledAttributes = (Properties)context.getTransientAppMetaData("previousEnabledAttributes", Properties.class);
        app.setName(deployParams.name);
        if (deployParams.libraries != null) {
            app.setLibraries(deployParams.libraries);
        }
        if (deployParams.description != null) {
            app.setDescription(deployParams.description);
        }
        if (deployParams.deploymentorder != null) {
            app.setDeploymentOrder(deployParams.deploymentorder.toString());
        }
        app.setEnabled(String.valueOf(true));
        if (appProps.getProperty("location") != null) {
            String enabledAttr;
            app.setLocation(appProps.getProperty("location"));
            if (DeploymentUtils.isDomainTarget((String)deployParams.target) && previousEnabledAttributes != null && (enabledAttr = previousEnabledAttributes.getProperty("domain")) != null) {
                app.setEnabled(enabledAttr);
            }
            app.setAvailabilityEnabled(deployParams.availabilityenabled.toString());
            app.setAsyncReplication(deployParams.asyncreplication.toString());
        }
        if (appProps.getProperty("object-type") != null) {
            app.setObjectType(appProps.getProperty("object-type"));
        }
        if (appProps.getProperty("directory-deployed") != null) {
            app.setDirectoryDeployed(appProps.getProperty("directory-deployed"));
        }
    }

    private void setRestAppAttributes(Application app, Properties appProps) throws PropertyVetoException, TransactionFailure {
        if (appProps.getProperty("context-root") != null) {
            app.setContextRoot(appProps.getProperty("context-root"));
        }
        for (Object element : appProps.keySet()) {
            String propName = (String)element;
            if (propName.equals("location") || propName.equals("context-root") || propName.equals("object-type") || propName.equals("directory-deployed") || propName.startsWith("appConfig") || appProps.getProperty(propName) == null) continue;
            Property prop = (Property)app.createChild(Property.class);
            app.getProperty().add(prop);
            prop.setName(propName);
            prop.setValue(appProps.getProperty(propName));
        }
    }

    public void unregisterAppFromDomainXML(String appName, String target) throws TransactionFailure {
        this.unregisterAppFromDomainXML(appName, target, false);
    }

    public void unregisterAppFromDomainXML(final String appName, final String tgt, final boolean appRefOnly) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    List targets = new ArrayList<String>();
                    if (!DeploymentUtils.isDomainTarget((String)tgt)) {
                        targets.add(tgt);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    if (!(param instanceof Domain)) {
                        return Boolean.FALSE;
                    }
                    Domain dmn = (Domain)param;
                    for (String target : targets) {
                        Cluster cluster;
                        Server servr = dmn.getServerNamed(target);
                        if (servr != null) {
                            ConfigBeanProxy servr_w = t.enroll((ConfigBeanProxy)servr);
                            for (ApplicationRef appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ((Server)servr_w).getApplicationRef().remove(appRef);
                                break;
                            }
                        }
                        if ((cluster = dmn.getClusterNamed(target)) == null) continue;
                        ConfigBeanProxy cluster_w = t.enroll((ConfigBeanProxy)cluster);
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ((Cluster)cluster_w).getApplicationRef().remove(appRef);
                            break;
                        }
                        block3: for (Server svr : cluster.getInstances()) {
                            ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ((Server)svr_w).getApplicationRef().remove(appRef);
                                continue block3;
                            }
                        }
                    }
                    if (!appRefOnly) {
                        Applications apps = dmn.getApplications();
                        ConfigBeanProxy apps_w = t.enroll((ConfigBeanProxy)apps);
                        for (ApplicationName module : apps.getModules()) {
                            if (!module.getName().equals(appName)) continue;
                            ((Applications)apps_w).getModules().remove(module);
                            break;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    public void updateAppEnabledAttributeInDomainXML(final String appName, final String target, final boolean enabled) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    if (!(param instanceof Domain)) {
                        return Boolean.FALSE;
                    }
                    Domain dmn = (Domain)param;
                    if (enabled || DeploymentUtils.isDomainTarget((String)target)) {
                        Application app = dmn.getApplications().getApplication(appName);
                        ConfigBeanProxy app_w = t.enroll((ConfigBeanProxy)app);
                        ((Application)app_w).setEnabled(String.valueOf(enabled));
                    }
                    List<String> targets = new ArrayList<String>();
                    if (!DeploymentUtils.isDomainTarget((String)target)) {
                        targets.add(target);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    for (String target2 : targets) {
                        Cluster cluster;
                        Server servr = dmn.getServerNamed(target2);
                        if (servr != null) {
                            for (ApplicationRef appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                break;
                            }
                            ApplicationLifecycle.this.updateClusterAppRefWithInstanceUpdate(t, servr, appName, enabled);
                        }
                        if ((cluster = dmn.getClusterNamed(target2)) == null) continue;
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                            ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                            break;
                        }
                        block3: for (Server svr : cluster.getInstances()) {
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                continue block3;
                            }
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    public boolean isRegistered(String appName) {
        return this.applications.getApplication(appName) != null;
    }

    public ApplicationInfo get(String appName) {
        return this.appRegistry.get(appName);
    }

    private boolean isPaaSEnabled(Boolean isClassicStyle) {
        if (isClassicStyle.booleanValue()) {
            return false;
        }
        return this.virtEnv != null && this.virtEnv.isPaasEnabled();
    }

    public String getDefaultTarget(Boolean isClassicStyle) {
        if (!this.isPaaSEnabled(isClassicStyle)) {
            return "server";
        }
        return null;
    }

    public String getDefaultTarget(String appName, OpsParams.Origin origin, Boolean isClassicStyle) {
        if (!this.isPaaSEnabled(isClassicStyle)) {
            return "server";
        }
        if (origin == OpsParams.Origin.deploy) {
            return null;
        }
        List targets = this.domain.getAllReferencedTargetsForApplication(appName);
        if (targets.size() == 0) {
            throw new IllegalArgumentException("Application not registered");
        }
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Cannot determine the default target. Please specify an explicit target for the operation.");
        }
        return (String)targets.get(0);
    }

    private void traceContainers(DeploymentTracing tracing, String[] containerNames, DeploymentTracing.ContainerMark containerMark) {
        if (tracing != null) {
            for (String containerName : containerNames) {
                tracing.addContainerMark(containerMark, containerName);
            }
        }
    }

    private void traceContainer(DeploymentTracing tracing, String containerName, DeploymentTracing.ContainerMark containerMark) {
        if (tracing != null) {
            tracing.addContainerMark(containerMark, containerName);
        }
    }

    public Deployment.DeploymentContextBuilder getBuilder(Logger logger, OpsParams params, ActionReport report) {
        return new DeploymentContextBuidlerImpl(logger, params, report);
    }

    private void updateClusterAppRefWithInstanceUpdate(Transaction t, Server servr, String appName, boolean isNewInstanceAppRefStateEnabled) throws TransactionFailure, PropertyVetoException {
        Cluster clusterContainingInstance = servr.getCluster();
        if (clusterContainingInstance != null) {
            boolean isAppRefEnabledOnAnyClusterInstance = false;
            for (Server inst : clusterContainingInstance.getInstances()) {
                isAppRefEnabledOnAnyClusterInstance |= servr.getName().equals(inst.getName()) ? isNewInstanceAppRefStateEnabled : Boolean.parseBoolean(inst.getApplicationRef(appName).getEnabled());
            }
            ApplicationRef clusterAppRef = clusterContainingInstance.getApplicationRef(appName);
            if (Boolean.parseBoolean(clusterAppRef.getEnabled()) != isAppRefEnabledOnAnyClusterInstance) {
                ((ApplicationRef)t.enroll((ConfigBeanProxy)clusterAppRef)).setEnabled(String.valueOf(isAppRefEnabledOnAnyClusterInstance));
            }
        }
    }

    private ReadableArchive getArchive(Deployment.DeploymentContextBuilder builder) throws IOException {
        ReadableArchive archive = builder.sourceAsArchive();
        if (archive == null && builder.sourceAsFile() == null) {
            throw new IOException("Source archive or file not provided to builder");
        }
        if (archive == null && builder.sourceAsFile() != null && (archive = ((ArchiveFactory)this.serviceLocator.getService(ArchiveFactory.class, new Annotation[0])).openArchive(builder.sourceAsFile())) == null) {
            throw new IOException("Invalid archive type : " + builder.sourceAsFile().getAbsolutePath());
        }
        return archive;
    }

    private ExtendedDeploymentContext getContext(ExtendedDeploymentContext initial, Deployment.DeploymentContextBuilder builder) throws IOException {
        ArchiveHandler archiveHandler;
        DeploymentContextBuidlerImpl copy = new DeploymentContextBuidlerImpl(builder);
        ReadableArchive archive = this.getArchive(copy);
        copy.source(archive);
        if (initial == null) {
            initial = new DeploymentContextImpl((Deployment.DeploymentContextBuilder)copy, (ServerEnvironment)this.env);
        }
        if ((archiveHandler = copy.archiveHandler()) == null) {
            String type = null;
            OpsParams params = builder.params();
            if (params != null) {
                if (params instanceof DeployCommandParameters) {
                    type = ((DeployCommandParameters)params).type;
                } else if (params instanceof UndeployCommandParameters) {
                    type = ((UndeployCommandParameters)params)._type;
                }
            }
            archiveHandler = this.getArchiveHandler(archive, type);
        }
        File sourceFile = new File(archive.getURI().getSchemeSpecificPart());
        initial.getAppProps().put("defaultAppName", DeploymentUtils.getDefaultEEName((String)sourceFile.getName()));
        if (!sourceFile.isDirectory()) {
            String repositoryBitName = copy.params().name();
            try {
                repositoryBitName = VersioningUtils.getRepositoryName((String)repositoryBitName);
            }
            catch (VersioningSyntaxException e) {
                ActionReport report = copy.report();
                report.setMessage(e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            File expansionDir = new File(this.domain.getApplicationRoot(), repositoryBitName);
            if (!expansionDir.mkdirs()) {
                LOG.fine(localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
            }
            try {
                Long start = System.currentTimeMillis();
                try (WritableArchive expandedArchive = this.archiveFactory.createArchive(expansionDir);){
                    archiveHandler.expand(archive, expandedArchive, (DeploymentContext)initial);
                    LOG.fine(() -> "Deployment expansion took " + (System.currentTimeMillis() - start) + " ms");
                    try {
                        archive.close();
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "NCLS-CORE-00031", new Object[]{archive.getURI().getSchemeSpecificPart(), e});
                        throw e;
                    }
                    initial.setSource((ReadableArchive)expandedArchive);
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "NCLS-CORE-00032", e);
                throw e;
            }
        }
        initial.setArchiveHandler(archiveHandler);
        return initial;
    }

    private void setAppRefAttributes(ApplicationRef appRef, DeployCommandParameters deployParams) throws PropertyVetoException {
        appRef.setRef(deployParams.name);
        if (deployParams.virtualservers != null) {
            appRef.setVirtualServers(deployParams.virtualservers);
        } else {
            appRef.setVirtualServers(DeploymentUtils.getVirtualServers((String)deployParams.target, (ServerEnvironment)this.env, (Domain)this.domain));
        }
        if (deployParams.lbenabled != null) {
            appRef.setLbEnabled(deployParams.lbenabled);
        } else {
            String lbEnabledDefault = System.getProperty("org.glassfish.lb-enabled-default");
            if (lbEnabledDefault != null) {
                appRef.setLbEnabled(lbEnabledDefault);
            }
        }
        appRef.setEnabled(deployParams.enabled.toString());
    }

    public ParameterMap prepareInstanceDeployParamMap(DeploymentContext dc) throws Exception {
        Properties previousEnabledAttributes;
        String runtimeAltDDLocation;
        String altDDLocation;
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        ArrayList<String> excludedParams = new ArrayList<String>();
        excludedParams.add("path");
        excludedParams.add("deploymentplan");
        excludedParams.add("altdd");
        excludedParams.add("runtimealtdd");
        excludedParams.add("upload");
        ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{params});
        ParameterMap paramMap = extractor.extract(excludedParams);
        this.prepareGeneratedContent(dc, paramMap);
        Application application = this.applications.getApplication(params.name);
        Properties appProperties = application.getDeployProperties();
        String archiveLocation = appProperties.getProperty("appLocation");
        File archiveFile = new File(new URI(archiveLocation));
        paramMap.set((Object)"DEFAULT", (Object)archiveFile.getAbsolutePath());
        String planLocation = appProperties.getProperty("deploymentPlanLocation");
        if (planLocation != null) {
            File actualPlan = new File(new URI(planLocation));
            paramMap.set((Object)"deploymentplan", (Object)actualPlan.getAbsolutePath());
        }
        if ((altDDLocation = appProperties.getProperty("altDDLocation")) != null) {
            File altDD = new File(new URI(altDDLocation));
            paramMap.set((Object)"altdd", (Object)altDD.getAbsolutePath());
        }
        if ((runtimeAltDDLocation = appProperties.getProperty("runtimeAltDDLocation")) != null) {
            File runtimeAltDD = new File(new URI(runtimeAltDDLocation));
            paramMap.set((Object)"runtimealtdd", (Object)runtimeAltDD.getAbsolutePath());
        }
        paramMap.set((Object)"upload", (Object)"true");
        if (params.previousContextRoot != null) {
            paramMap.set((Object)"preservedcontextroot", (Object)params.previousContextRoot);
        }
        Properties appProps = dc.getAppProps();
        appProps.remove("appConfig");
        paramMap.set((Object)"appprops", (Object)extractor.propertiesValue(appProps, ':'));
        Properties previousVirtualServers = (Properties)dc.getTransientAppMetaData("previousVirtualServers", Properties.class);
        if (previousVirtualServers != null) {
            paramMap.set((Object)"previousVirtualServers", (Object)extractor.propertiesValue(previousVirtualServers, ':'));
        }
        if ((previousEnabledAttributes = (Properties)dc.getTransientAppMetaData("previousEnabledAttributes", Properties.class)) != null) {
            paramMap.set((Object)"previousEnabledAttributes", (Object)extractor.propertiesValue(previousEnabledAttributes, ':'));
        }
        return paramMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareGeneratedContent(DeploymentContext dc, ParameterMap paramMap) throws IOException {
        File generatedContentZip = this.createGeneratedContentZip();
        File baseDir = dc.getScratchDir("xml").getParentFile().getParentFile();
        try (ZipOutputStream zipOS = null;){
            for (String scratchType : UPLOADED_GENERATED_DIRS) {
                File genDir = dc.getScratchDir(scratchType);
                if (!genDir.isDirectory()) continue;
                if (zipOS == null) {
                    zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(generatedContentZip)));
                }
                this.addFileToZip(zipOS, baseDir, genDir);
            }
        }
        if (zipOS != null) {
            paramMap.set((Object)"generatedcontent", (Object)generatedContentZip.getAbsolutePath());
        }
    }

    private File createGeneratedContentZip() throws IOException {
        File tempFile = File.createTempFile("gendContent", ".zip");
        tempFile.deleteOnExit();
        return tempFile;
    }

    private void addFileToZip(ZipOutputStream zipOS, File baseDir, File f) throws IOException {
        String entryName = baseDir.toURI().relativize(f.toURI()).getPath();
        ZipEntry entry = new ZipEntry(entryName);
        zipOS.putNextEntry(entry);
        if (f.isDirectory()) {
            zipOS.closeEntry();
            for (File subFile : f.listFiles()) {
                this.addFileToZip(zipOS, baseDir, subFile);
            }
        } else {
            FileUtils.copy((File)f, (OutputStream)zipOS);
            zipOS.closeEntry();
        }
    }

    public void validateDeploymentTarget(String target, String name, boolean isRedeploy) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.isEmpty()) {
            if (this.isRegistered(name)) {
                if (!isRedeploy && DeploymentUtils.isDomainTarget((String)target)) {
                    throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
                }
                if (!DeploymentUtils.isDomainTarget((String)target)) {
                    throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref_2", "Application {0} is already deployed in this domain. Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
                }
            }
            return;
        }
        if (!isRedeploy) {
            if (DeploymentUtils.isDomainTarget((String)target)) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.deploy_domain", "Application with name {0} is already referenced by other target(s). Please specify force option to redeploy to domain.", new Object[]{name}));
            }
            if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
            }
            throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref", "Application {0} is already referenced by other target(s). Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
        }
        if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
            return;
        }
        if (!DeploymentUtils.isDomainTarget((String)target)) {
            throw new IllegalArgumentException(localStrings.getLocalString("redeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove other references or specify all targets (or domain target if using asadmin command line) before attempting redeploy operation.", new Object[]{name}));
        }
    }

    public void validateUndeploymentTarget(String target, String name) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.size() > 1) {
            Application app = this.applications.getApplication(name);
            if (!DeploymentUtils.isDomainTarget((String)target)) {
                if (app.isLifecycleModule()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("delete_lifecycle_on_multiple_targets", "Lifecycle module {0} is referenced by more than one targets. Please remove other references before attempting delete operation.", new Object[]{name}));
                }
                throw new IllegalArgumentException(localStrings.getLocalString("undeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove other references or specify all targets (or domain target if using asadmin command line) before attempting undeploy operation.", new Object[]{name}));
            }
        }
    }

    public void validateSpecifiedTarget(String target) {
        if (this.env.isDas()) {
            if (target == null) {
                return;
            }
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && cluster.isVirtual()) {
                throw new IllegalArgumentException(localStrings.getLocalString("cannot_specify_managed_target", "Cannot specify target {0} for the operation. Target {0} is a managed target.", new Object[]{target}));
            }
        }
    }

    public boolean isAppEnabled(Application app) {
        ApplicationRef appRef;
        return Boolean.parseBoolean(app.getEnabled()) && (appRef = this.server.getApplicationRef(app.getName())) != null && Boolean.valueOf(appRef.getEnabled()) != false;
    }

    public ExtendedDeploymentContext disable(UndeployCommandParameters commandParams, Application app, ApplicationInfo appInfo, ActionReport report, Logger logger) throws Exception {
        if (appInfo == null || !this.env.isDas() && !appInfo.isLoaded()) {
            return null;
        }
        if (app != null) {
            commandParams._type = app.archiveType();
        }
        ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, (OpsParams)commandParams, report).source(appInfo.getSource()).build();
        if (app != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
            deploymentContext.setModulePropsMap(app.getModulePropertiesMap());
        }
        if (commandParams.properties != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)commandParams.properties);
        }
        this.unload(appInfo, deploymentContext);
        return deploymentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedDeploymentContext enable(String target, Application app, ApplicationRef appRef, ActionReport report, Logger logger) throws Exception {
        ReadableArchive archive = null;
        DeployCommandParameters commandParams = app.getDeployParameters(appRef);
        ApplicationInfo appInfo = this.appRegistry.get(commandParams.name);
        if (appInfo != null && appInfo.isLoaded()) {
            ExtendedDeploymentContext extendedDeploymentContext = null;
            return extendedDeploymentContext;
        }
        commandParams.origin = OpsParams.Origin.load;
        commandParams.command = OpsParams.Command.enable;
        commandParams.target = target;
        commandParams.enabled = Boolean.TRUE;
        Properties contextProps = app.getDeployProperties();
        Map modulePropsMap = app.getModulePropertiesMap();
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(app);
        URI uri = new URI(app.getLocation());
        File file = new File(uri);
        if (!file.exists()) {
            throw new Exception(localStrings.getLocalString("fnf", "File not found {0}", new Object[]{file.getAbsolutePath()}));
        }
        archive = this.archiveFactory.openArchive(file);
        ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, (OpsParams)commandParams, report).source(archive).build();
        Properties appProps = deploymentContext.getAppProps();
        appProps.putAll((Map<?, ?>)contextProps);
        savedAppConfig.store(appProps);
        if (modulePropsMap != null) {
            deploymentContext.setModulePropsMap(modulePropsMap);
        }
        this.deploy(this.getSniffersFromApp(app), deploymentContext);
        ExtendedDeploymentContext extendedDeploymentContext = deploymentContext;
        return extendedDeploymentContext;
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean loadOnCurrentInstance(DeploymentContext context) {
        DeployCommandParameters commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        Properties appProps = context.getAppProps();
        if (commandParams.enabled.booleanValue()) {
            String objectType;
            if (this.domain.isCurrentInstanceMatchingTarget(commandParams.target, commandParams.name(), this.server.getName(), (List)context.getTransientAppMetaData("previousTargets", List.class))) {
                return true;
            }
            if (this.server.isDas() && (objectType = appProps.getProperty("object-type")) != null && (objectType.equals("system-admin") || objectType.equals("system-all"))) {
                return true;
            }
        }
        return false;
    }

    private String getApplicationType(ApplicationInfo appInfo) {
        StringBuffer sb = new StringBuffer();
        if (appInfo.getSniffers().size() > 0) {
            for (Sniffer sniffer : appInfo.getSniffers()) {
                if (!sniffer.isUserVisible()) continue;
                sb.append(sniffer.getModuleType() + ", ");
            }
        }
        if (sb.length() > 2) {
            return sb.substring(0, sb.length() - 2);
        }
        return sb.toString();
    }

    public List<Sniffer> getSniffersFromApp(Application app) {
        ArrayList<String> snifferTypes = new ArrayList<String>();
        for (Module module : app.getModule()) {
            for (Engine engine : module.getEngines()) {
                snifferTypes.add(engine.getSniffer());
            }
        }
        if (snifferTypes.isEmpty()) {
            return null;
        }
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        if (app.isStandaloneModule()) {
            for (String snifferType : snifferTypes) {
                Sniffer sniffer = this.snifferManager.getSniffer(snifferType);
                if (sniffer != null) {
                    sniffers.add(sniffer);
                    continue;
                }
                LOG.log(Level.SEVERE, "NCLS-CORE-00033", snifferType);
            }
            if (sniffers.isEmpty()) {
                LOG.log(Level.SEVERE, "NCLS-CORE-00034", app.getName());
                return null;
            }
        } else {
            return null;
        }
        return sniffers;
    }

    private ExecutorService createExecutorService() {
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        return Executors.newFixedThreadPool(nrOfProcessors, new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("deployment-jar-scanner");
                t.setContextClassLoader(this.getClass().getClassLoader());
                t.setDaemon(true);
                return t;
            }
        });
    }

    private static /* synthetic */ String lambda$deploy$0(EngineInfo i) {
        return i.getSniffer().getModuleType();
    }

    public class DeploymentContextBuidlerImpl
    implements Deployment.DeploymentContextBuilder {
        private final Logger logger;
        private final ActionReport report;
        private final OpsParams params;
        private File sFile;
        private ReadableArchive sArchive;
        private ArchiveHandler handler;

        public DeploymentContextBuidlerImpl(Logger logger, OpsParams params, ActionReport report) {
            this.logger = logger;
            this.report = report;
            this.params = params;
        }

        public DeploymentContextBuidlerImpl(Deployment.DeploymentContextBuilder b) throws IOException {
            this.logger = b.logger();
            this.report = b.report();
            this.params = b.params();
            ReadableArchive archive = ApplicationLifecycle.this.getArchive(b);
            this.source(archive);
            this.handler = b.archiveHandler();
        }

        public Deployment.DeploymentContextBuilder source(File source) {
            this.sFile = source;
            return this;
        }

        public File sourceAsFile() {
            return this.sFile;
        }

        public ReadableArchive sourceAsArchive() {
            return this.sArchive;
        }

        public ArchiveHandler archiveHandler() {
            return this.handler;
        }

        public Deployment.DeploymentContextBuilder source(ReadableArchive archive) {
            this.sArchive = archive;
            return this;
        }

        public Deployment.DeploymentContextBuilder archiveHandler(ArchiveHandler handler) {
            this.handler = handler;
            return this;
        }

        public ExtendedDeploymentContext build() throws IOException {
            return this.build(null);
        }

        public Logger logger() {
            return this.logger;
        }

        public ActionReport report() {
            return this.report;
        }

        public OpsParams params() {
            return this.params;
        }

        public ExtendedDeploymentContext build(ExtendedDeploymentContext initialContext) throws IOException {
            return ApplicationLifecycle.this.getContext(initialContext, this);
        }
    }
}

