/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class UnaryArithmeticOperatorNode
extends UnaryOperatorNode {
    private static final String[] UNARY_OPERATORS = new String[]{"+", "-", "SQRT", "ABS/ABSVAL"};
    private static final String[] UNARY_METHODS = new String[]{"plus", "minus", "sqrt", "absolute"};
    static final int K_PLUS = 0;
    static final int K_MINUS = 1;
    static final int K_SQRT = 2;
    static final int K_ABS = 3;
    final int kind;

    UnaryArithmeticOperatorNode(ValueNode valueNode, int n, ContextManager contextManager) throws StandardException {
        super(valueNode, UNARY_OPERATORS[n], UNARY_METHODS[n], contextManager);
        this.kind = n;
    }

    @Override
    public boolean requiresTypeFromContext() {
        if (this.kind == 0 || this.kind == 1) {
            return this.operand.requiresTypeFromContext();
        }
        return false;
    }

    @Override
    public boolean isParameterNode() {
        if (this.kind == 0 || this.kind == 1) {
            return this.operand.isParameterNode();
        }
        return false;
    }

    @Override
    void bindParameter() throws StandardException {
        if (this.kind == 2 || this.kind == 3) {
            this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true));
            return;
        }
        if (this.kind == 1 || this.kind == 0) {
            return;
        }
        super.bindParameter();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (this.operand.requiresTypeFromContext() && (this.kind == 0 || this.kind == 1) && this.operand.getTypeServices() == null) {
            return this;
        }
        this.bindOperand(fromList, subqueryList, list);
        if (this.kind == 2 || this.kind == 3) {
            this.bindSQRTABS();
        } else if (this.kind == 0 || this.kind == 1) {
            this.checkOperandIsNumeric(this.operand.getTypeId());
        }
        super.setType(this.operand.getTypeServices());
        return this;
    }

    private void checkOperandIsNumeric(TypeId typeId) throws StandardException {
        if (!typeId.isNumericTypeId()) {
            throw StandardException.newException("42X37", this.kind == 0 ? "+" : "-", typeId.getSQLTypeName());
        }
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.kind == 0) {
            this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        } else {
            super.generateExpression(expressionClassBuilder, methodBuilder);
        }
    }

    private void bindSQRTABS() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId.userType()) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
        int n = typeId.getJDBCTypeId();
        if (!typeId.isNumericTypeId()) {
            throw StandardException.newException("42X25", this.getOperatorString(), typeId.getSQLTypeName());
        }
        if (this.kind == 2 && n != 8) {
            this.operand = new CastNode(this.operand, new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
        }
    }

    @Override
    void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (this.operand.requiresTypeFromContext() && this.operand.getTypeServices() == null) {
            this.checkOperandIsNumeric(dataTypeDescriptor.getTypeId());
            this.operand.setType(dataTypeDescriptor);
        }
        super.setType(dataTypeDescriptor);
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((UnaryArithmeticOperatorNode)valueNode).kind == this.kind;
    }
}

