/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;

public class PlannedShutdownSignalImpl
implements PlannedShutdownSignal {
    private String memberToken;
    private String groupName;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private GMSContext ctx;
    private long startTime;
    private GMSConstants.shutdownType shutdownType;
    private AliveAndReadyView previousView = null;
    private AliveAndReadyView currentView = null;

    public PlannedShutdownSignalImpl(String memberToken, String groupName, long startTime, GMSConstants.shutdownType shutdownType2) {
        this.memberToken = memberToken;
        this.groupName = groupName;
        this.startTime = startTime;
        this.shutdownType = shutdownType2;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    PlannedShutdownSignalImpl(PlannedShutdownSignal signal) {
        this.memberToken = signal.getMemberToken();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.shutdownType = signal.getEventSubType();
        this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        this.previousView = signal.getPreviousView();
        this.currentView = signal.getCurrentView();
    }

    public void acquire() throws SignalAcquireException {
    }

    public void release() throws SignalReleaseException {
        this.memberToken = null;
    }

    public String getMemberToken() {
        return this.memberToken;
    }

    public Map<Serializable, Serializable> getMemberDetails() {
        return this.ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public GMSConstants.shutdownType getEventSubType() {
        return this.shutdownType;
    }

    public AliveAndReadyView getCurrentView() {
        return this.currentView;
    }

    public AliveAndReadyView getPreviousView() {
        return this.previousView;
    }

    void setCurrentView(AliveAndReadyView current) {
        this.currentView = current;
    }

    void setPreviousView(AliveAndReadyView previous) {
        this.previousView = previous;
    }
}

