/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.StatementWrapper;
import com.sun.gjc.util.ResultSetClosedEventListener;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;

public abstract class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement,
ResultSetClosedEventListener {
    protected PreparedStatement preparedStatement;
    private boolean busy;
    private boolean cached;
    private int defaultMaxFieldSize;
    private int defaultMaxRows;
    private int defaultQueryTimeout;
    private int defaultFetchDirection;
    private int defaultFetchSize;
    private int currentMaxFieldSize;
    private int currentMaxRows;
    private int currentQueryTimeout;
    private int currentFetchDirection;
    private int currentFetchSize;
    private boolean valid = true;

    public PreparedStatementWrapper(Connection con, PreparedStatement statement, boolean cachingEnabled) throws SQLException {
        super(con, statement);
        this.preparedStatement = statement;
        this.cached = cachingEnabled;
        ConnectionHolder wrappedCon = (ConnectionHolder)con;
        this.leakDetector = wrappedCon.getManagedConnection().getLeakDetector();
        if (this.cached) {
            this.defaultQueryTimeout = this.preparedStatement.getQueryTimeout();
            this.defaultMaxFieldSize = this.preparedStatement.getMaxFieldSize();
            this.defaultFetchSize = this.preparedStatement.getFetchSize();
            this.defaultMaxRows = this.preparedStatement.getMaxRows();
            this.defaultFetchDirection = this.preparedStatement.getFetchDirection();
            this.currentQueryTimeout = this.defaultQueryTimeout;
            this.currentMaxFieldSize = this.defaultMaxFieldSize;
            this.currentFetchSize = this.defaultFetchSize;
            this.currentMaxRows = this.defaultMaxRows;
            this.currentFetchDirection = this.defaultFetchDirection;
        } else if (this.leakDetector != null) {
            this.leakDetector.startStatementLeakTracing(this.preparedStatement, this);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.preparedStatement.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.preparedStatement.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.preparedStatement.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.preparedStatement.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.preparedStatement.setRef(i, x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.preparedStatement.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.preparedStatement.setClob(i, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.preparedStatement.setArray(i, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.preparedStatement.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.preparedStatement.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.preparedStatement.getParameterMetaData();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        if (busy) {
            if (this.leakDetector != null) {
                this.leakDetector.startStatementLeakTracing(this.preparedStatement, this);
            }
        } else if (this.leakDetector != null) {
            this.leakDetector.stopStatementLeakTracing(this.preparedStatement, this);
            if (this.cached && this.isMarkedForReclaim()) {
                this.setValid(false);
            }
        }
    }

    public boolean getCached() {
        return this.cached;
    }

    @Override
    public void close() throws SQLException {
        if (!this.cached) {
            if (this.leakDetector != null) {
                this.leakDetector.stopStatementLeakTracing(this.preparedStatement, this);
            }
            this.preparedStatement.close();
        } else {
            this.clearParameters();
            if (this.defaultQueryTimeout != this.currentQueryTimeout) {
                this.preparedStatement.setQueryTimeout(this.defaultQueryTimeout);
                this.currentQueryTimeout = this.defaultQueryTimeout;
            }
            if (this.defaultMaxFieldSize != this.currentMaxFieldSize) {
                this.preparedStatement.setMaxFieldSize(this.defaultMaxFieldSize);
                this.currentMaxFieldSize = this.defaultMaxFieldSize;
            }
            if (this.defaultFetchSize != this.currentFetchSize) {
                this.preparedStatement.setFetchSize(this.defaultFetchSize);
                this.currentFetchSize = this.defaultFetchSize;
            }
            if (this.defaultMaxRows != this.currentMaxRows) {
                this.preparedStatement.setMaxRows(this.defaultMaxRows);
                this.currentMaxRows = this.defaultMaxRows;
            }
            if (this.defaultFetchDirection != this.currentFetchDirection) {
                this.preparedStatement.setFetchDirection(this.defaultFetchDirection);
                this.currentFetchDirection = this.defaultFetchDirection;
            }
            this.setBusy(false);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (!this.cached) {
            if (this.leakDetector != null) {
                _logger.log(Level.INFO, "jdbc.invalid_operation.close_on_completion");
                throw new UnsupportedOperationException("Not supported yet.");
            }
            this.actualCloseOnCompletion();
        } else {
            super.closeOnCompletion();
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.cached) {
            return this.getCloseOnCompletion();
        }
        return super.isCloseOnCompletion();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.preparedStatement.setMaxFieldSize(max);
        if (this.cached) {
            this.currentMaxFieldSize = max;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
        if (this.cached) {
            this.currentMaxRows = max;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.preparedStatement.setQueryTimeout(seconds);
        if (this.cached) {
            this.currentQueryTimeout = seconds;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.preparedStatement.setFetchDirection(direction);
        if (this.cached) {
            this.currentFetchDirection = direction;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.preparedStatement.setFetchSize(rows);
        if (this.cached) {
            this.currentFetchSize = rows;
        }
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void incrementResultSetReferenceCount() {
        if (this.getCached()) {
            this.incrementResultSetCount();
        }
    }

    @Override
    public void resultSetClosed() throws SQLException {
        if (this.getCached()) {
            this.decrementResultSetCount();
            if (this.getCloseOnCompletion() && this.getResultSetCount() == 0) {
                ConnectionHolder wrappedCon = (ConnectionHolder)this.getConnection();
                wrappedCon.getManagedConnection().purgeStatementFromCache(this);
            }
        }
    }
}

