/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api.events;

import java.util.Optional;
import javax.security.auth.Subject;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.security.common.UserPrincipal;

public class CommandInvokedEvent {
    private final String commandName;
    private final ParameterMap parameters;
    private final Subject subject;

    public CommandInvokedEvent(String commandName, ParameterMap parameters, Subject subject) {
        this.commandName = commandName;
        this.parameters = parameters != null ? parameters : new ParameterMap();
        this.subject = subject;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public ParameterMap getParameters() {
        return this.parameters;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Optional<UserPrincipal> getUserPrincipal() {
        return this.subject.getPrincipals().stream().filter(principal -> principal instanceof UserPrincipal).map(UserPrincipal.class::cast).findAny();
    }
}

