/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.commons.AbstractTaskManager;
import com.sun.xml.ws.commons.NamedThreadFactory;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ScheduledTaskManager
extends AbstractTaskManager {
    private static final Logger LOGGER = Logger.getLogger(ScheduledTaskManager.class);
    private static final AtomicInteger instanceNumber = new AtomicInteger(1);
    private static final long DELAY = 2000L;
    private static final long PERIOD = 100L;
    private final String name;
    private final Queue<ScheduledFuture<?>> scheduledTaskHandles;
    private final Component component;
    private final String threadNamePrefix;

    public ScheduledTaskManager(String name, Component component) {
        this.name = name.trim();
        this.component = component;
        this.threadNamePrefix = this.name.toLowerCase().replaceAll("\\s+", "-") + "-scheduler-" + instanceNumber.getAndIncrement();
        this.scheduledTaskHandles = new ConcurrentLinkedQueue();
    }

    public void stopAllTasks() {
        ScheduledFuture<?> handle;
        while ((handle = this.scheduledTaskHandles.poll()) != null) {
            handle.cancel(false);
        }
    }

    public void shutdown() {
        this.stopAllTasks();
        this.close(true, 2000L);
    }

    public ScheduledFuture<?> startTask(Runnable task, long initialDelay, long period) {
        ScheduledFuture<?> taskHandle = this.getExecutorService().scheduleAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
        if (!this.scheduledTaskHandles.offer(taskHandle)) {
            LOGGER.warning(String.format("Unable to store handle for task of class [ %s ]", task.getClass().getName()));
        }
        return taskHandle;
    }

    public ScheduledFuture<?> runOnce(Runnable task) {
        return this.startTask(task, 2000L, 100L);
    }

    @Override
    protected ThreadFactory createThreadFactory() {
        return new NamedThreadFactory(this.threadNamePrefix);
    }

    @Override
    protected String getThreadPoolName() {
        return this.threadNamePrefix;
    }

    @Override
    protected int getThreadPoolSize() {
        return 1;
    }

    @Override
    protected Component getComponent() {
        return this.component;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

