/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util.webservice;

import com.sun.enterprise.deployment.util.webservice.SEIConfig;
import com.sun.enterprise.deployment.util.webservice.WSDLConfig;
import com.sun.enterprise.deployment.util.webservice.WsCompileInvokerException;
import java.io.IOException;
import java.util.HashMap;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class WsCompileInvoker {
    protected HashMap wsCompileOptions = null;
    public static final String CLASS_PATH = "-classpath";
    public static final String TARGET_DIR = "-d";
    public static final String MAP_FILE = "-mapping";

    public abstract void generateWSDL(SEIConfig var1) throws WsCompileInvokerException, IOException;

    public abstract void generateSEI(WSDLConfig var1) throws WsCompileInvokerException, IOException;

    public abstract void generateClientStubs(WSDLConfig var1) throws WsCompileInvokerException, IOException;

    public void addWsCompileOption(String option, String operand) {
        if (this.wsCompileOptions == null) {
            this.wsCompileOptions = new HashMap();
        }
        this.wsCompileOptions.put(option, operand);
    }

    public boolean removeWsCompileOption(String option) {
        if (this.wsCompileOptions != null && this.wsCompileOptions.containsKey(option)) {
            this.wsCompileOptions.remove(option);
            return true;
        }
        return false;
    }

    public void addWsCompileFeature(String feature) {
        this.addWsCompileOption("-f:" + feature, null);
    }

    public boolean removeWsCompileFeature(String feature) {
        return this.removeWsCompileOption("-f:" + feature);
    }

    public void clearWsCompileOptionsAndFeatures() {
        if (this.wsCompileOptions != null) {
            this.wsCompileOptions.clear();
        }
    }
}

