/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.metro.api.config.management;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpMetadataPublisher;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;

class ManagedHttpMetadataPublisher
extends HttpMetadataPublisher
implements Component {
    private static final Logger LOGGER = Logger.getLogger(ManagedHttpMetadataPublisher.class);

    ManagedHttpMetadataPublisher() {
    }

    public <T> T getSPI(Class<T> spiType) {
        if (spiType.isAssignableFrom(this.getClass())) {
            return spiType.cast(this);
        }
        return null;
    }

    @Override
    public boolean handleMetadataRequest(HttpAdapter adapter, WSHTTPConnection connection) throws IOException {
        String query = connection.getQueryString();
        if (this.isWSDLQuery(query)) {
            this.publishWSDL(connection, adapter);
            return true;
        }
        if (this.isInitQuery(query)) {
            LOGGER.info(ManagementMessages.WSM_5100_INIT_RECEIVED());
            return true;
        }
        return false;
    }

    private boolean isWSDLQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl"));
    }

    private boolean isInitQuery(String query) {
        return query != null && query.equalsIgnoreCase("init-cm");
    }

    private void publishWSDL(@NotNull WSHTTPConnection connection, @NotNull HttpAdapter adapter) throws IOException {
        ServiceDefinition currentServiceDefinition = adapter.getEndpoint().getServiceDefinition();
        if (adapter.getServiceDefinition() != currentServiceDefinition) {
            adapter.initWSDLMap(currentServiceDefinition);
        }
        adapter.publishWSDL(connection);
    }
}

