/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.FileCacheStatsProvider;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="file-cache-mon", group="monitoring")
@ManagedObject
@Description(value="File Cache Statistics")
public class FileCacheStatsProviderGlobal
extends FileCacheStatsProvider {
    public FileCacheStatsProviderGlobal(String name) {
        super(name);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:countHitEvent")
    public void countHitEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.hitsCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:countMissEvent")
    public void countMissEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.missesCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:countInfoHitEvent")
    public void countInfoHitEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.infoHitsCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:countInfoMissEvent")
    public void countInfoMissEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.infoMissesCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:countContentHitEvent")
    public void countContentHitEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.contentHitsCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:countContentMissEvent")
    public void countContentMissEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.contentMissesCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:incOpenCacheEntriesEvent")
    public void incOpenCacheEntriesEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.openCacheEntriesCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:decOpenCacheEntriesEvent")
    public void decOpenCacheEntriesEvent(@ProbeParam(value="fileCacheName") String fileCacheName) {
        this.openCacheEntriesCount.decrement();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:addHeapSizeEvent")
    public void addHeapSizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        long maxSize;
        long newSize = this.heapSize.addAndGet(size);
        while (newSize > (maxSize = this.maxHeapSize.get()) && !this.maxHeapSize.compareAndSet(maxSize, newSize)) {
        }
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:subHeapSizeEvent")
    public void subHeapSizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        this.heapSize.addAndGet(-size);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:addMappedMemorySizeEvent")
    public void addMappedMemorySizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        long maxMemSize;
        long newSize = this.mappedMemorySize.addAndGet(size);
        while (newSize > (maxMemSize = this.maxMappedMemorySize.get()) && !this.maxMappedMemorySize.compareAndSet(maxMemSize, newSize)) {
        }
    }

    @Override
    @ProbeListener(value="glassfish:kernel:file-cache:subMappedMemorySizeEvent")
    public void subMappedMemorySizeEvent(@ProbeParam(value="fileCacheName") String fileCacheName, @ProbeParam(value="size") long size) {
        this.mappedMemorySize.addAndGet(-size);
    }
}

