/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;

public class Bindings {
    public static final Set<Annotation> DEFAULT_QUALIFIERS = ImmutableSet.of(new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE});

    private Bindings() {
    }

    public static boolean areQualifiersEquivalent(Annotation qualifier1, Annotation qualifier2, MetaAnnotationStore store) {
        Bindings.checkQualifier(qualifier1, store);
        Bindings.checkQualifier(qualifier2, store);
        QualifierInstance q1 = QualifierInstance.of(qualifier1, store);
        QualifierInstance q2 = QualifierInstance.of(qualifier2, store);
        return q1.equals(q2);
    }

    public static int getQualifierHashCode(Annotation qualifier, MetaAnnotationStore store) {
        Bindings.checkQualifier(qualifier, store);
        return QualifierInstance.of(qualifier, store).hashCode();
    }

    private static void checkQualifier(Annotation qualifier, MetaAnnotationStore store) {
        Preconditions.checkNotNull(qualifier);
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(qualifier.annotationType());
        if (model == null || !model.isValid()) {
            throw BeanManagerLogger.LOG.invalidQualifier(qualifier);
        }
    }

    public static void validateQualifiers(Iterable<Annotation> qualifiers, BeanManager manager, Object definer, String nullErrorMessage) {
        if (qualifiers == null) {
            throw MetadataLogger.LOG.qualifiersNull(nullErrorMessage, definer);
        }
        for (Annotation annotation : qualifiers) {
            if (manager.isQualifier(annotation.annotationType())) continue;
            throw MetadataLogger.LOG.notAQualifier(annotation.annotationType(), definer);
        }
    }

    public static boolean areInterceptorBindingsEquivalent(Annotation qualifier1, Annotation qualifier2, MetaAnnotationStore store) {
        Bindings.checkInterceptorBinding(qualifier1, store);
        Bindings.checkInterceptorBinding(qualifier2, store);
        QualifierInstance q1 = QualifierInstance.of(qualifier1, store);
        QualifierInstance q2 = QualifierInstance.of(qualifier2, store);
        return q1.equals(q2);
    }

    public static int getInterceptorBindingHashCode(Annotation qualifier, MetaAnnotationStore store) {
        Bindings.checkInterceptorBinding(qualifier, store);
        return QualifierInstance.of(qualifier, store).hashCode();
    }

    private static void checkInterceptorBinding(Annotation qualifier, MetaAnnotationStore store) {
        Preconditions.checkNotNull(qualifier);
        InterceptorBindingModel<? extends Annotation> model = store.getInterceptorBindingModel(qualifier.annotationType());
        if (model == null || !model.isValid()) {
            throw BeanManagerLogger.LOG.interceptorResolutionWithNonbindingType(qualifier);
        }
    }

    public static Set<Annotation> normalizeBeanQualifiers(Set<Annotation> qualifiers) {
        if (qualifiers.isEmpty()) {
            return DEFAULT_QUALIFIERS;
        }
        Set<Annotation> normalized = new HashSet<Annotation>(qualifiers);
        normalized.remove(Any.Literal.INSTANCE);
        normalized.remove(Default.Literal.INSTANCE);
        if (normalized.isEmpty()) {
            normalized = DEFAULT_QUALIFIERS;
        } else {
            ImmutableSet.Builder<Annotation> builder = ImmutableSet.builder();
            if (normalized.size() == 1 && normalized.iterator().next().annotationType().equals(Named.class)) {
                builder.add(Default.Literal.INSTANCE);
            }
            builder.add(Any.Literal.INSTANCE);
            builder.addAll((Iterable<Annotation>)qualifiers);
            normalized = builder.build();
        }
        return normalized;
    }
}

