/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.impl.sql.execute.BaseActivation;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;

public class MatchingClauseConstantAction
implements ConstantAction,
Formatable {
    private static final long serialVersionUID = -6725483265211088817L;
    private static final int FIRST_VERSION = 0;
    private int _clauseType;
    private String _matchRefinementName;
    private ResultDescription _thenColumnSignature;
    private String _rowMakingMethodName;
    private String _resultSetFieldName;
    private String _actionMethodName;
    private ConstantAction _thenAction;
    private transient GeneratedMethod _matchRefinementMethod;
    private transient GeneratedMethod _rowMakingMethod;
    private transient ResultSet _actionRS;

    public MatchingClauseConstantAction() {
    }

    public MatchingClauseConstantAction(int n, String string, ResultDescription resultDescription, String string2, String string3, String string4, ConstantAction constantAction) {
        this._clauseType = n;
        this._matchRefinementName = string;
        this._thenColumnSignature = resultDescription;
        this._rowMakingMethodName = string2;
        this._resultSetFieldName = string3;
        this._actionMethodName = string4;
        this._thenAction = constantAction;
    }

    public int clauseType() {
        return this._clauseType;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation, TemporaryRowHolderImpl temporaryRowHolderImpl) throws StandardException {
        if (temporaryRowHolderImpl == null) {
            return;
        }
        CursorResultSet cursorResultSet = temporaryRowHolderImpl.getResultSet();
        GeneratedMethod generatedMethod = ((BaseActivation)activation).getMethod(this._actionMethodName);
        try {
            activation.pushConstantAction(this._thenAction);
            try {
                Field field = activation.getClass().getField(this._resultSetFieldName);
                field.set(activation, cursorResultSet);
                Activation activation2 = cursorResultSet.getActivation();
                Method method = activation.getClass().getMethod(this._actionMethodName, new Class[0]);
                this._actionRS = (ResultSet)method.invoke((Object)activation, null);
            }
            catch (Exception exception) {
                throw StandardException.plainWrapException(exception);
            }
            this._actionRS.open();
        }
        finally {
            activation.popConstantAction();
        }
    }

    void init() throws StandardException {
        this._actionRS = null;
    }

    boolean evaluateRefinementClause(Activation activation) throws StandardException {
        SQLBoolean sQLBoolean;
        if (this._matchRefinementName == null) {
            return true;
        }
        if (this._matchRefinementMethod == null) {
            this._matchRefinementMethod = ((BaseActivation)activation).getMethod(this._matchRefinementName);
        }
        if ((sQLBoolean = (SQLBoolean)this._matchRefinementMethod.invoke(activation)).isNull()) {
            return false;
        }
        return sQLBoolean.getBoolean();
    }

    TemporaryRowHolderImpl bufferThenRow(Activation activation, TemporaryRowHolderImpl temporaryRowHolderImpl, ExecRow execRow) throws StandardException {
        if (temporaryRowHolderImpl == null) {
            temporaryRowHolderImpl = this.createThenRows(activation);
        }
        ExecRow execRow2 = this.bufferThenRow(activation);
        temporaryRowHolderImpl.insert(execRow2);
        return temporaryRowHolderImpl;
    }

    void cleanUp() throws StandardException {
        if (this._actionRS != null) {
            this._actionRS.close();
            this._actionRS = null;
        }
        this._matchRefinementMethod = null;
        this._rowMakingMethod = null;
    }

    private ExecRow bufferThenRow(Activation activation) throws StandardException {
        if (this._rowMakingMethod == null) {
            this._rowMakingMethod = ((BaseActivation)activation).getMethod(this._rowMakingMethodName);
        }
        return (ExecRow)this._rowMakingMethod.invoke(activation);
    }

    private TemporaryRowHolderImpl createThenRows(Activation activation) throws StandardException {
        return new TemporaryRowHolderImpl(activation, new Properties(), this._thenColumnSignature);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this._clauseType = objectInput.readInt();
        this._matchRefinementName = (String)objectInput.readObject();
        this._thenColumnSignature = (ResultDescription)objectInput.readObject();
        this._rowMakingMethodName = (String)objectInput.readObject();
        this._resultSetFieldName = (String)objectInput.readObject();
        this._actionMethodName = (String)objectInput.readObject();
        this._thenAction = (ConstantAction)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(this._clauseType);
        objectOutput.writeObject(this._matchRefinementName);
        objectOutput.writeObject(this._thenColumnSignature);
        objectOutput.writeObject(this._rowMakingMethodName);
        objectOutput.writeObject(this._resultSetFieldName);
        objectOutput.writeObject(this._actionMethodName);
        objectOutput.writeObject(this._thenAction);
    }

    @Override
    public int getTypeFormatId() {
        return 476;
    }
}

