/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.cfg.ContextServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedExecutorServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedScheduledExecutorServiceCfg;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedThreadFactoryCfg;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceAdapter;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;

public class ConcurrentObjectFactory
implements ObjectFactory {
    private static final Logger LOG = LogDomains.getLogger(ConcurrentObjectFactory.class, (String)"jakarta.enterprise.system.core.naming", (boolean)false);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) {
        LOG.log(Level.FINE, "getObjectInstance(obj={0}, name={1}, nameCtx, environment)", new Object[]{obj, name});
        Reference ref = (Reference)obj;
        Object config = ref.get(0).getContent();
        if (config instanceof ContextServiceCfg) {
            return this.getContextService((ContextServiceCfg)config);
        }
        if (config instanceof ManagedThreadFactoryCfg) {
            return this.getManagedThreadFactory((ManagedThreadFactoryCfg)config);
        }
        if (config instanceof ManagedExecutorServiceCfg) {
            return this.getManagedExecutorService((ManagedExecutorServiceCfg)config);
        }
        if (config instanceof ManagedScheduledExecutorServiceCfg) {
            return this.getManagedScheduledExecutorService((ManagedScheduledExecutorServiceCfg)config);
        }
        throw new IllegalArgumentException("Unknown type of " + String.valueOf(config));
    }

    private ContextServiceImpl getContextService(ContextServiceCfg config) {
        return ConcurrentRuntime.getRuntime().getContextService(config);
    }

    private ManagedThreadFactoryImpl getManagedThreadFactory(ManagedThreadFactoryCfg config) {
        return ConcurrentRuntime.getRuntime().getManagedThreadFactory(config);
    }

    private ManagedExecutorServiceAdapter getManagedExecutorService(ManagedExecutorServiceCfg config) {
        return ConcurrentRuntime.getRuntime().getManagedExecutorService(config).getAdapter();
    }

    private ManagedScheduledExecutorServiceAdapter getManagedScheduledExecutorService(ManagedScheduledExecutorServiceCfg config) {
        return ConcurrentRuntime.getRuntime().getManagedScheduledExecutorService(config).getAdapter();
    }
}

