/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.AsymmetricBinding;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.Claims;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.IssuerName;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SCTokenWrapper
extends PolicyAssertion
implements SecureConversationToken {
    private SecureConversationToken scToken = null;
    private MessagePolicy messagePolicy = null;
    private List<PolicyAssertion> issuedTokenList = null;
    private List<PolicyAssertion> kerberosTokenList = null;
    private boolean cached = false;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;

    public SCTokenWrapper(PolicyAssertion scToken, MessagePolicy mp) {
        super(AssertionData.createAssertionData(scToken.getName(), scToken.getValue(), scToken.getAttributes(), scToken.isOptional(), scToken.isIgnorable()), SCTokenWrapper.getAssertionParameters(scToken), scToken.getNestedPolicy() == null ? null : scToken.getNestedPolicy().getAssertionSet());
        this.scToken = (SecureConversationToken)((Object)scToken);
        this.messagePolicy = mp;
        String nsUri = scToken.getName().getNamespaceURI();
        if (SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri.equals(nsUri)) {
            this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        } else if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(nsUri)) {
            this.spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
        }
    }

    private static Collection<PolicyAssertion> getAssertionParameters(PolicyAssertion scToken) {
        Iterator<PolicyAssertion> itr;
        if (scToken.hasParameters() && (itr = scToken.getParametersIterator()).hasNext()) {
            return Collections.singletonList(itr.next());
        }
        return null;
    }

    public SecureConversationToken getSecureConversationToken() {
        return this.scToken;
    }

    public void setSecureConversationToken(SecureConversationToken scToken) {
        this.scToken = scToken;
    }

    public MessagePolicy getMessagePolicy() {
        return this.messagePolicy;
    }

    public void setMessagePolicyp(MessagePolicy mp) {
        this.messagePolicy = mp;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        return this.scToken.isRequireDerivedKeys();
    }

    @Override
    public boolean isMustNotSendCancel() {
        return this.scToken.isMustNotSendCancel();
    }

    @Override
    public boolean isMustNotSendRenew() {
        return this.scToken.isMustNotSendRenew();
    }

    @Override
    public String getTokenType() {
        return this.scToken.getTokenType();
    }

    @Override
    public Issuer getIssuer() {
        return this.scToken.getIssuer();
    }

    @Override
    public IssuerName getIssuerName() {
        return this.scToken.getIssuerName();
    }

    @Override
    public Claims getClaims() {
        return this.scToken.getClaims();
    }

    @Override
    public NestedPolicy getBootstrapPolicy() {
        return this.scToken.getBootstrapPolicy();
    }

    @Override
    public String getIncludeToken() {
        return this.scToken.getIncludeToken();
    }

    @Override
    public String getTokenId() {
        return this.scToken.getTokenId();
    }

    public List<PolicyAssertion> getIssuedTokens() {
        if (!this.cached && this.hasNestedPolicy()) {
            this.getTokens(this.getNestedPolicy());
            this.cached = true;
        }
        return this.issuedTokenList;
    }

    public List<PolicyAssertion> getKerberosTokens() {
        if (!this.cached && this.hasNestedPolicy()) {
            this.getTokens(this.getNestedPolicy());
            this.cached = true;
        }
        return this.kerberosTokenList;
    }

    private void getTokens(NestedPolicy policy) {
        this.issuedTokenList = new ArrayList<PolicyAssertion>();
        this.kerberosTokenList = new ArrayList<PolicyAssertion>();
        AssertionSet assertionSet = policy.getAssertionSet();
        for (PolicyAssertion pa : assertionSet) {
            if (!PolicyUtil.isBootstrapPolicy(pa, this.spVersion)) continue;
            NestedPolicy np = pa.getNestedPolicy();
            AssertionSet bpSet = np.getAssertionSet();
            for (PolicyAssertion assertion : bpSet) {
                Binding sb;
                if (PolicyUtil.isAsymmetricBinding(assertion, this.spVersion)) {
                    sb = (AsymmetricBinding)((Object)assertion);
                    Token iToken = sb.getInitiatorToken();
                    if (iToken != null) {
                        this.addToken(iToken);
                    } else {
                        this.addToken(sb.getInitiatorSignatureToken());
                        this.addToken(sb.getInitiatorEncryptionToken());
                    }
                    Token rToken = sb.getRecipientToken();
                    if (rToken != null) {
                        this.addToken(rToken);
                        continue;
                    }
                    this.addToken(sb.getRecipientSignatureToken());
                    this.addToken(sb.getRecipientEncryptionToken());
                    continue;
                }
                if (PolicyUtil.isSymmetricBinding(assertion, this.spVersion)) {
                    sb = (SymmetricBinding)((Object)assertion);
                    Token token = sb.getProtectionToken();
                    if (token != null) {
                        this.addToken(token);
                        continue;
                    }
                    this.addToken(sb.getEncryptionToken());
                    this.addToken(sb.getSignatureToken());
                    continue;
                }
                if (!PolicyUtil.isSupportingTokens(assertion, this.spVersion)) continue;
                SupportingTokens st = (SupportingTokens)((Object)assertion);
                Iterator itr = st.getTokens();
                while (itr.hasNext()) {
                    this.addToken((Token)itr.next());
                }
            }
        }
    }

    private void addToken(Token token) {
        if (token != null) {
            if (PolicyUtil.isIssuedToken((PolicyAssertion)((Object)token), this.spVersion)) {
                this.issuedTokenList.add((PolicyAssertion)((Object)token));
            } else if (PolicyUtil.isKerberosToken((PolicyAssertion)((Object)token), this.spVersion)) {
                this.kerberosTokenList.add((PolicyAssertion)((Object)token));
            }
        }
    }

    @Override
    public Set getTokenRefernceTypes() {
        return this.scToken.getTokenRefernceTypes();
    }

    public void addBootstrapPolicy(NestedPolicy policy) {
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

