/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base.datastructure;

import com.sun.gjc.monitoring.StatementCacheProbeProvider;
import com.sun.gjc.spi.base.CacheObjectKey;
import com.sun.gjc.spi.base.PreparedStatementWrapper;
import com.sun.gjc.spi.base.datastructure.Cache;
import com.sun.logging.LogDomains;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class LRUCacheImpl
implements Cache {
    protected static final Logger _logger = LogDomains.getLogger(LRUCacheImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private final Map<CacheObjectKey, CacheEntry> list;
    private final int maxSize;
    private StatementCacheProbeProvider probeProvider;
    private final PoolInfo poolInfo;

    public LRUCacheImpl(PoolInfo poolInfo, int maxSize) {
        this.maxSize = maxSize;
        this.poolInfo = poolInfo;
        this.list = new LinkedHashMap<CacheObjectKey, CacheEntry>();
        try {
            this.probeProvider = new StatementCacheProbeProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object checkAndUpdateCache(CacheObjectKey key) {
        Object result = null;
        CacheEntry entry = this.list.get(key);
        if (entry != null) {
            result = entry.entryObj;
            _logger.finest("Cache Hit");
            this.probeProvider.statementCacheHitEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        } else {
            _logger.finest("Cache Miss");
            this.probeProvider.statementCacheMissEvent(this.poolInfo.getName().toString(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
        }
        return result;
    }

    @Override
    public void addToCache(CacheObjectKey key, Object o, boolean force) {
        if (force || !this.list.containsKey(key)) {
            if (this.list.size() >= this.maxSize) {
                this.purge();
            }
            CacheEntry entry = new CacheEntry(o);
            this.list.put(key, entry);
        }
    }

    @Override
    public void clearCache() {
        _logger.fine("clearing objects in cache");
        this.list.clear();
    }

    @Override
    public void flushCache() {
        while (this.list.size() != 0) {
            this.purge();
        }
    }

    @Override
    public void purge() {
        block2: {
            Set<Map.Entry<CacheObjectKey, CacheEntry>> entrySet = this.list.entrySet();
            Iterator<Map.Entry<CacheObjectKey, CacheEntry>> entrySetIterator = entrySet.iterator();
            if (!entrySetIterator.hasNext()) break block2;
            Map.Entry<CacheObjectKey, CacheEntry> entryTuple = entrySetIterator.next();
            CacheEntry entry = entryTuple.getValue();
            try {
                PreparedStatementWrapper ps = (PreparedStatementWrapper)entry.entryObj;
                ps.setCached(false);
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            entrySetIterator.remove();
        }
    }

    @Override
    public void purge(Object obj) {
        block3: {
            PreparedStatementWrapper tmpPS = (PreparedStatementWrapper)obj;
            Set<Map.Entry<CacheObjectKey, CacheEntry>> entrySet = this.list.entrySet();
            Iterator<Map.Entry<CacheObjectKey, CacheEntry>> entrySetIterator = entrySet.iterator();
            if (!entrySetIterator.hasNext()) break block3;
            Map.Entry<CacheObjectKey, CacheEntry> entryTuple = entrySetIterator.next();
            CacheEntry entry = entryTuple.getValue();
            try {
                PreparedStatementWrapper ps = (PreparedStatementWrapper)entry.entryObj;
                if (ps.equals(tmpPS)) {
                    _logger.log(Level.FINEST, "Purging an entry from cache");
                    ps.setCached(false);
                    ps.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            entrySetIterator.remove();
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public static class CacheEntry {
        private final Object entryObj;

        public CacheEntry(Object o) {
            this.entryObj = o;
        }
    }
}

