/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashSet;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRDynamicEntity;
import org.eclipse.persistence.internal.xr.XRDynamicEntityAccessor;
import org.eclipse.persistence.internal.xr.XRDynamicEntityVHAccessor;
import org.eclipse.persistence.internal.xr.XRDynamicPropertiesManager;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public final class ProjectHelper {
    private ProjectHelper() {
    }

    public static void fixOROXAccessors(Project orProject, Project oxProject) {
        XRDynamicClassLoader xrdecl;
        ConversionManager conversionManager;
        Platform platform;
        for (ClassDescriptor desc : orProject.getDescriptors().values()) {
            if (!XRDynamicEntity.class.isAssignableFrom(desc.getJavaClass())) continue;
            Class clz = desc.getJavaClass();
            ClassDescriptor xdesc = null;
            if (oxProject != null) {
                xdesc = oxProject.getDescriptorForAlias(desc.getAlias());
            }
            XRDynamicPropertiesManager xrDPM = null;
            if (!clz.getName().endsWith("_CollectionWrapper")) {
                try {
                    XRDynamicEntity newInstance = (XRDynamicEntity)((Object)clz.getConstructor(new Class[0]).newInstance(new Object[0]));
                    xrDPM = newInstance.fetchPropertiesManager();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HashSet<String> propertiesNameSet = new HashSet<String>();
            for (DatabaseMapping dm : desc.getMappings()) {
                String attributeName = dm.getAttributeName();
                DatabaseMapping xdm = null;
                if (xdesc != null) {
                    xdm = xdesc.getMappingForAttributeName(attributeName);
                }
                dm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(dm));
                if (xdm != null) {
                    if (dm.isForeignReferenceMapping()) {
                        ForeignReferenceMapping frm = (ForeignReferenceMapping)dm;
                        if (frm.usesIndirection() && frm.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                            xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityVHAccessor(dm));
                        } else {
                            xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(dm));
                        }
                    } else {
                        xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(dm));
                    }
                }
                propertiesNameSet.add(attributeName);
            }
            if (xrDPM == null) continue;
            xrDPM.setPropertyNames(propertiesNameSet);
        }
        ClassLoader cl = null;
        Login login = orProject.getDatasourceLogin();
        if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
            cl = conversionManager.getLoader();
        }
        if (cl instanceof XRDynamicClassLoader) {
            xrdecl = (XRDynamicClassLoader)((Object)cl);
            xrdecl.dontGenerateSubclasses();
        }
        if (oxProject != null) {
            cl = null;
            login = oxProject.getDatasourceLogin();
            if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
                cl = conversionManager.getLoader();
            }
            if (cl instanceof XRDynamicClassLoader) {
                xrdecl = (XRDynamicClassLoader)((Object)cl);
                xrdecl.dontGenerateSubclasses();
            }
        }
    }
}

