/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.BlankLine;
import org.jboss.jdeparser.BlockJComment;
import org.jboss.jdeparser.ClassContent;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JClassDefSection;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.LineJComment;
import org.jboss.jdeparser.Sectionable;
import org.jboss.jdeparser.SourceFileWriter;

class JClassDefSectionImpl
implements JClassDefSection,
ClassContent {
    private final Sectionable sectionable;
    private final ArrayList<ClassContent> content = new ArrayList();

    JClassDefSectionImpl(Sectionable sectionable) {
        this.sectionable = sectionable;
    }

    <C extends ClassContent> C add(C item) {
        this.content.add(item);
        return item;
    }

    @Override
    public JClassDefSection section() {
        return this.add(new JClassDefSectionImpl(this.sectionable));
    }

    @Override
    public JClassDefSection blankLine() {
        this.add(BlankLine.getInstance());
        return this;
    }

    @Override
    public JBlock init() {
        return this.sectionable.init(this.content);
    }

    @Override
    public JBlock staticInit() {
        return this.sectionable.staticInit(this.content);
    }

    @Override
    public JVarDeclaration field(int mods, JType type, String name) {
        return this.sectionable.field(this.content, mods, type, name, null);
    }

    @Override
    public JVarDeclaration field(int mods, JType type, String name, JExpr init) {
        return this.sectionable.field(this.content, mods, type, name, init);
    }

    @Override
    public JVarDeclaration field(int mods, Class<?> type, String name) {
        return this.field(mods, JTypes.typeOf(type), name);
    }

    @Override
    public JVarDeclaration field(int mods, Class<?> type, String name, JExpr init) {
        return this.field(mods, JTypes.typeOf(type), name, init);
    }

    @Override
    public JVarDeclaration field(int mods, String type, String name) {
        return this.field(mods, JTypes.typeNamed(type), name);
    }

    @Override
    public JVarDeclaration field(int mods, String type, String name, JExpr init) {
        return this.field(mods, JTypes.typeNamed(type), name, init);
    }

    @Override
    public JMethodDef method(int mods, JType returnType, String name) {
        return this.sectionable.method(this.content, mods, returnType, name);
    }

    @Override
    public JMethodDef method(int mods, Class<?> returnType, String name) {
        return this.method(mods, JTypes.typeOf(returnType), name);
    }

    @Override
    public JMethodDef method(int mods, String returnType, String name) {
        return this.method(mods, JTypes.typeNamed(returnType), name);
    }

    @Override
    public JMethodDef constructor(int mods) {
        return this.sectionable.constructor(this.content, mods);
    }

    @Override
    public JClassDef _class(int mods, String name) {
        return this.sectionable._class(this.content, mods, name);
    }

    @Override
    public JClassDef _enum(int mods, String name) {
        return this.sectionable._enum(this.content, mods, name);
    }

    @Override
    public JClassDef _interface(int mods, String name) {
        return this.sectionable._interface(this.content, mods, name);
    }

    @Override
    public JClassDef annotationInterface(int mods, String name) {
        return this.sectionable.annotationInterface(this.content, mods, name);
    }

    @Override
    public JComment lineComment() {
        return this.add(new LineJComment());
    }

    @Override
    public JComment blockComment() {
        return this.add(new BlockJComment());
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        Iterator<ClassContent> iterator = this.content.iterator();
        if (iterator.hasNext()) {
            iterator.next().write(writer);
            while (iterator.hasNext()) {
                writer.nl();
                iterator.next().write(writer);
            }
        }
    }
}

