/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.rx.mc.api.McProtocolVersion;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.security.impl.policyconv.SCTokenWrapper;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.policy.PolicyAlternatives;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import com.sun.xml.wss.provider.wsit.PolicyAlternativeHolder;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AlternativesBasedPolicyResolver
implements PolicyResolver {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private WSDLBoundOperation cachedOperation = null;
    private AddressingVersion addVer = null;
    private RmProtocolVersion rmVer = null;
    private McProtocolVersion mcVer = null;
    private TubeConfiguration tubeConfig = null;
    private boolean isClient = false;
    private boolean isSCMessage = false;
    private String action = "";
    private WSTrustVersion wstVer = WSTrustVersion.WS_TRUST_10;
    private WSSCVersion wsscVer = WSSCVersion.WSSC_10;
    private List<PolicyAlternativeHolder> policyAlternatives = null;

    public AlternativesBasedPolicyResolver(List<PolicyAlternativeHolder> alternatives, WSDLBoundOperation cachedOperation, TubeConfiguration tubeConfig, AddressingVersion addVer, boolean client, RmProtocolVersion rmVer, McProtocolVersion mcVer) {
        this.policyAlternatives = alternatives;
        this.cachedOperation = cachedOperation;
        this.tubeConfig = tubeConfig;
        this.addVer = addVer;
        this.isClient = client;
        this.rmVer = rmVer;
        this.mcVer = mcVer;
    }

    @Override
    public SecurityPolicy resolvePolicy(ProcessingContext ctx) {
        Message msg = null;
        SOAPMessage soapMsg = null;
        if (ctx instanceof JAXBFilterProcessingContext) {
            msg = ((JAXBFilterProcessingContext)ctx).getJAXWSMessage();
        } else {
            soapMsg = ctx.getSOAPMessage();
            msg = Messages.create(soapMsg);
        }
        if (((ProcessingContextImpl)ctx).getSecurityPolicyVersion().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) {
            this.wstVer = WSTrustVersion.WS_TRUST_13;
            this.wsscVer = WSSCVersion.WSSC_13;
        }
        this.action = this.getAction(msg);
        if (this.isRMMessage() || this.isMCMessage()) {
            return this.getProtocolPolicy("RM");
        }
        if (this.isSCCancel()) {
            return this.getProtocolPolicy("SC-CANCEL");
        }
        SecurityPolicy mp = null;
        this.isSCMessage = this.isSCMessage();
        if (this.isSCMessage) {
            Token scToken = (Token)((Object)this.getInBoundSCP());
            return this.getInboundXWSBootstrapPolicy(scToken);
        }
        if (msg.isFault()) {
            if (soapMsg == null) {
                try {
                    soapMsg = msg.readAsSOAPMessage();
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
            }
            mp = this.getInboundFaultPolicy(soapMsg);
        } else {
            mp = this.getInboundXWSSecurityPolicy(msg);
        }
        if (mp == null) {
            return new MessagePolicy();
        }
        return mp;
    }

    protected PolicyAssertion getInBoundSCP() {
        SecurityPolicyHolder sph = null;
        ArrayList<SecurityPolicyHolder> coll = new ArrayList<SecurityPolicyHolder>();
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            coll.addAll(p.getInMessagePolicyMap().values());
        }
        for (SecurityPolicyHolder ph : coll) {
            if (ph == null) continue;
            sph = ph;
            break;
        }
        if (sph == null) {
            return null;
        }
        List<PolicyAssertion> policies = sph.getSecureConversationTokens();
        if (!policies.isEmpty()) {
            return policies.get(0);
        }
        return null;
    }

    private SecurityPolicy getInboundXWSSecurityPolicy(Message msg) {
        Object mp = null;
        WSDLBoundOperation operation = null;
        if (this.cachedOperation != null) {
            operation = this.cachedOperation;
        } else {
            operation = msg.getOperation(this.tubeConfig.getWSDLPort());
            if (operation == null) {
                operation = this.getWSDLOpFromAction();
            }
        }
        ArrayList<MessagePolicy> mps = new ArrayList<MessagePolicy>();
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            SecurityPolicyHolder sph = p.getInMessagePolicyMap().get(operation);
            if (sph == null && (this.isTrustMessage() || this.isSCMessage)) {
                operation = this.getWSDLOpFromAction();
                sph = p.getInMessagePolicyMap().get(operation);
            }
            if (sph == null) continue;
            mps.add(this.cloneWithId(sph.getMessagePolicy(), p.getId()));
        }
        return new PolicyAlternatives(mps);
    }

    private SecurityPolicy getInboundFaultPolicy(SOAPMessage msg) {
        if (this.cachedOperation != null) {
            ArrayList<MessagePolicy> mps = new ArrayList<MessagePolicy>();
            for (PolicyAlternativeHolder p : this.policyAlternatives) {
                WSDLOperation operation = this.cachedOperation.getOperation();
                try {
                    Node faultNode;
                    SOAPBody body = msg.getSOAPBody();
                    NodeList nodes = body.getElementsByTagName("detail");
                    if (nodes.getLength() == 0) {
                        nodes = body.getElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
                    }
                    if (nodes.getLength() <= 0) continue;
                    Node node = nodes.item(0);
                    for (faultNode = node.getFirstChild(); faultNode != null && faultNode.getNodeType() != 1; faultNode = faultNode.getNextSibling()) {
                    }
                    if (faultNode == null) {
                        return new MessagePolicy();
                    }
                    String uri = faultNode.getNamespaceURI();
                    QName faultDetail = uri != null && uri.length() > 0 ? new QName(uri, faultNode.getLocalName()) : new QName(faultNode.getLocalName());
                    WSDLFault fault = operation.getFault(faultDetail);
                    SecurityPolicyHolder sph = p.getInMessagePolicyMap().get(this.cachedOperation);
                    SecurityPolicyHolder faultPolicyHolder = sph.getFaultPolicy(fault);
                    if (faultPolicyHolder == null) continue;
                    mps.add(this.cloneWithId(faultPolicyHolder.getMessagePolicy(), p.getId()));
                }
                catch (SOAPException sx) {
                    log.log(Level.WARNING, LogStringsMessages.WSITPVD_0065_ERROR_RESOLVING_ALTERNATIVES(), sx);
                }
            }
            return new PolicyAlternatives(mps);
        }
        return new MessagePolicy();
    }

    private boolean isTrustMessage() {
        return this.wstVer.getIssueRequestAction().equals(this.action) || this.wstVer.getIssueResponseAction().equals(this.action);
    }

    private boolean isRMMessage() {
        return this.rmVer.isProtocolAction(this.action);
    }

    private boolean isMCMessage() {
        return this.mcVer.isProtocolAction(this.action);
    }

    private String getAction(Message msg) {
        if (this.addVer != null) {
            MessageHeaders hl = msg.getHeaders();
            return AddressingUtils.getAction(hl, this.addVer, this.tubeConfig.getBinding().getSOAPVersion());
        }
        return "";
    }

    private SecurityPolicy getInboundXWSBootstrapPolicy(Token scAssertion) {
        if (scAssertion == null) {
            return null;
        }
        return ((SCTokenWrapper)scAssertion).getMessagePolicy();
    }

    private boolean isSCMessage() {
        return this.wsscVer.getSCTRequestAction().equals(this.action) || this.wsscVer.getSCTResponseAction().equals(this.action) || this.wsscVer.getSCTRenewRequestAction().equals(this.action) || this.wsscVer.getSCTRenewResponseAction().equals(this.action);
    }

    private boolean isSCCancel() {
        return this.wsscVer.getSCTCancelResponseAction().equals(this.action) || this.wsscVer.getSCTCancelRequestAction().equals(this.action);
    }

    private String getAction(WSDLOperation operation) {
        if (!this.isClient) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private WSDLBoundOperation getWSDLOpFromAction() {
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            Set<WSDLBoundOperation> keys = p.getInMessagePolicyMap().keySet();
            for (WSDLBoundOperation wbo : keys) {
                WSDLOperation wo = wbo.getOperation();
                String confAction = this.getAction(wo);
                if (confAction == null || !confAction.equals(this.action)) continue;
                return wbo;
            }
        }
        return null;
    }

    private SecurityPolicy getProtocolPolicy(String protocol) {
        ArrayList<MessagePolicy> mps = new ArrayList<MessagePolicy>();
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            SecurityPolicyHolder sph = p.getInProtocolPM().get(protocol);
            if (sph == null) continue;
            mps.add(this.cloneWithId(sph.getMessagePolicy(), p.getId()));
        }
        return new PolicyAlternatives(mps);
    }

    private MessagePolicy cloneWithId(MessagePolicy toClone, String id) {
        if (toClone == null) {
            return null;
        }
        try {
            MessagePolicy copy = new MessagePolicy();
            copy.setPolicyAlternativeId(id);
            Iterator it = toClone.iterator();
            while (it.hasNext()) {
                copy.append((SecurityPolicy)it.next());
            }
            return copy;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

