/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;

public class InterceptorBindingSet
extends AbstractSet<Annotation> {
    private BeanManagerImpl beanManager;
    private Set<Annotation> set = new HashSet<Annotation>();

    public InterceptorBindingSet(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public boolean add(Annotation annotation) {
        if (this.contains(annotation)) {
            return false;
        }
        return this.set.add(annotation);
    }

    @Override
    public Iterator<Annotation> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Annotation) {
            Annotation annotation = (Annotation)o;
            MetaAnnotationStore metaAnnotationStore = this.beanManager.getServices().get(MetaAnnotationStore.class);
            InterceptorBindingModel<? extends Annotation> interceptorBindingModel = metaAnnotationStore.getInterceptorBindingModel(annotation.annotationType());
            for (Annotation containedAnnotation : this.set) {
                if (!interceptorBindingModel.isEqual(annotation, containedAnnotation)) continue;
                return true;
            }
            return false;
        }
        return super.contains(o);
    }
}

