/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.standalone;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.eclipse.acceleo.aql.migration.IModuleResolver;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class StandaloneModuleResolver
implements IModuleResolver {
    private static final String BIN_FOLDER_NAME = "bin";
    private static final String DELIMITER = "::";
    private Path binFolderPath;

    public StandaloneModuleResolver(Path binFolderPath) {
        this.binFolderPath = binFolderPath;
    }

    @Override
    public String getQualifiedName(Module module, Module refModule) {
        URI refModuleURI = EcoreUtil.getURI((EObject)refModule);
        Path emtlPath = null;
        if (refModuleURI.isPlatformResource() || refModuleURI.isPlatformPlugin()) {
            emtlPath = Paths.get(String.valueOf(this.binFolderPath.toFile().getParentFile().getParentFile()) + refModuleURI.toPlatformString(true), new String[0]);
        } else {
            Path modulePath = Paths.get(EcoreUtil.getURI((EObject)module).trimFragment().toFileString(), new String[0]);
            Path refModulePath = Paths.get(refModuleURI.trimFragment().toFileString(), new String[0]);
            emtlPath = modulePath.getParent().resolve(refModulePath).normalize();
        }
        if (emtlPath.toFile().exists()) {
            try {
                return this.getModuleQualifiedName(emtlPath);
            }
            catch (IOException e) {
                System.err.println("Unable to resolve " + String.valueOf(refModuleURI));
                e.printStackTrace();
            }
        }
        System.err.println("File not found " + String.valueOf(emtlPath));
        return null;
    }

    private String getModuleQualifiedName(Path emtlFile) throws IOException {
        String moduleName = StandaloneModuleResolver.readModuleName(emtlFile);
        StringBuffer res = new StringBuffer();
        if (emtlFile.startsWith(this.binFolderPath)) {
            Path relevant = this.binFolderPath.relativize(emtlFile.getParent());
            for (Path path : relevant) {
                res.append(path);
                res.append(DELIMITER);
            }
        } else {
            Iterator<Path> emtlPathIterator = emtlFile.getParent().iterator();
            boolean relevant = false;
            while (emtlPathIterator.hasNext()) {
                Path path = emtlPathIterator.next();
                if (relevant) {
                    res.append(path);
                    res.append(DELIMITER);
                }
                if (!BIN_FOLDER_NAME.equals(path.toString())) continue;
                relevant = true;
            }
        }
        res.append(moduleName);
        return res.toString();
    }

    private static String readModuleName(Path emtlFile) throws IOException {
        String res = null;
        for (String line : Files.readAllLines(emtlFile)) {
            String prefix = "<mtl:Module name=\"";
            if (!line.trim().startsWith(prefix)) continue;
            res = line.trim().substring(prefix.length());
            res = res.substring(0, res.indexOf("\"")).trim();
            break;
        }
        return res;
    }
}

