/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.net.URI;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.references.FileAndURIMatchContentProvider;
import org.eclipse.lsp4e.operations.references.FileAndURIMatchLabelProvider;
import org.eclipse.lsp4e.operations.references.URIMatch;
import org.eclipse.search.internal.ui.text.DecoratingFileSearchLabelProvider;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileTreeContentProvider;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.Match;

public class LSSearchResultPage
extends FileSearchPage {
    public void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        FileTreeContentProvider fileMatchContentProvider = (FileTreeContentProvider)viewer.getContentProvider();
        FileAndURIMatchContentProvider contentProvider = new FileAndURIMatchContentProvider(fileMatchContentProvider);
        viewer.setContentProvider((IContentProvider)contentProvider);
        DecoratingFileSearchLabelProvider fileMatchDecoratingLabelProvider = (DecoratingFileSearchLabelProvider)viewer.getLabelProvider();
        FileAndURIMatchLabelProvider.FileAndURIMatchBaseLabelProvider baseLabelProvider = new FileAndURIMatchLabelProvider.FileAndURIMatchBaseLabelProvider(fileMatchDecoratingLabelProvider.getStyledStringProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FileAndURIMatchLabelProvider(baseLabelProvider, fileMatchDecoratingLabelProvider));
        viewer.setComparator(new ViewerComparator(){

            public int category(@Nullable Object element) {
                if (element instanceof IContainer) {
                    return 1;
                }
                if (element instanceof URI) {
                    URI uri = (URI)element;
                    if ("file".equals(uri.getScheme())) {
                        return 2;
                    }
                    return 3;
                }
                return 4;
            }

            public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (e1 instanceof LineElement) {
                    LineElement m1 = (LineElement)e1;
                    if (e2 instanceof LineElement) {
                        LineElement m2 = (LineElement)e2;
                        return m1.getOffset() - m2.getOffset();
                    }
                }
                if (e1 instanceof URIMatch) {
                    URIMatch m1 = (URIMatch)((Object)e1);
                    if (e2 instanceof URIMatch) {
                        URIMatch m2 = (URIMatch)((Object)e2);
                        return m1.getOffset() - m2.getOffset();
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    protected void elementsChanged(Object[] objects) {
        this.getViewer().setInput((Object)this.getInput());
    }

    protected void clear() {
        this.getViewer().setInput((Object)new Object[0]);
    }

    protected void evaluateChangedElements(Match[] matches, Set<Object> changedElements) {
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            FileMatch fileMatch;
            Match match = matchArray[n2];
            if (match instanceof FileMatch && (fileMatch = (FileMatch)match).getLineElement() != null) {
                changedElements.add(fileMatch.getLineElement());
            } else {
                changedElements.add(match.getElement());
            }
            ++n2;
        }
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement instanceof URI) {
            URI uri = (URI)firstElement;
            LSPEclipseUtils.open(uri.toString(), this.getViewPart().getSite().getPage(), null);
            return;
        }
        if (firstElement instanceof URIMatch) {
            URIMatch uriMatch = (URIMatch)((Object)firstElement);
            LSPEclipseUtils.openInEditor(uriMatch.location, this.getViewPart().getSite().getPage());
            return;
        }
        super.handleOpen(event);
    }
}

