/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace.workspace;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IWorkspaceRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;

public class WorkspaceRegistry
extends EPackageRegistryImpl
implements IWorkspaceRegistry {
    private static final long serialVersionUID = -6908270616586400928L;
    private final IQueryWorkspace<?> workspace;
    private final Set<String> ePkgQualifiedNames = new HashSet<String>();
    private final Map<String, Set<String>> dependencies = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> dependsOn = new HashMap<String, Set<String>>();

    public WorkspaceRegistry(IQueryWorkspace<?> workspace) {
        super(EPackage.Registry.INSTANCE);
        this.workspace = workspace;
    }

    @Override
    public void register(Class<? extends EPackage> cls, String qualifiedName) {
        try {
            String nsURI = (String)cls.getDeclaredField("eNS_URI").get(null);
            Object registered = EPackage.Registry.INSTANCE.remove((Object)nsURI);
            try {
                EPackage ePkg = (EPackage)cls.getDeclaredField("eINSTANCE").get(null);
                this.put(nsURI, ePkg);
                this.ePkgQualifiedNames.add(qualifiedName);
                this.workspace.changeEPackage(nsURI);
            }
            finally {
                EPackage.Registry.INSTANCE.put((Object)nsURI, registered);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void register(URI uri, String qualifiedName) {
    }

    @Override
    public void setDependencies(String qualifiedName, Set<String> nsURIs) {
        Set<String> oldDepdencyNsURIs = this.dependencies.remove(qualifiedName);
        if (oldDepdencyNsURIs != null) {
            for (String oldDepdencyNsURI : oldDepdencyNsURIs) {
                Set<String> qualifiedNames = this.dependsOn.get(oldDepdencyNsURI);
                if (qualifiedNames == null || !qualifiedNames.remove(qualifiedName) || !qualifiedNames.isEmpty()) continue;
                this.dependsOn.remove(oldDepdencyNsURI);
            }
        }
        if (!nsURIs.isEmpty()) {
            this.dependencies.put(qualifiedName, nsURIs);
            for (String nsURI : nsURIs) {
                this.dependsOn.computeIfAbsent(nsURI, id -> new HashSet()).add(qualifiedName);
            }
        }
    }

    @Override
    public Set<String> getDependsOn(String nsURI) {
        return this.dependsOn.getOrDefault(nsURI, Collections.emptySet());
    }

    public Set<String> keySet() {
        LinkedHashSet<String> res = new LinkedHashSet<String>(super.keySet());
        res.addAll(this.delegateRegistry.keySet());
        return res;
    }

    @Override
    public boolean isEPackage(String qualifiedName) {
        return this.ePkgQualifiedNames.contains(qualifiedName);
    }
}

