/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.validation;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;

public class MarkerEraser {
    private static final Logger LOG = Logger.getLogger(MarkerEraser.class);

    public void deleteValidationMarkers(IFile file, CheckMode checkMode, IProgressMonitor monitor) {
        if (this.shouldProcess(file)) {
            try {
                this.deleteMarkers(file, checkMode, monitor);
            }
            catch (CoreException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public final boolean shouldProcess(IFile file) {
        return file.isAccessible() && file.getProject().isAccessible() && !file.getProject().isHidden();
    }

    public void deleteMarkers(IFile file, CheckMode checkMode, IProgressMonitor monitor) throws CoreException {
        CheckType[] checkTypeArray = CheckType.values();
        int n = checkTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CheckType chkType = checkTypeArray[n2];
            if (checkMode.shouldCheck(chkType)) {
                String markerType = MarkerTypes.forCheckType(chkType);
                file.deleteMarkers(markerType, true, 0);
            }
            ++n2;
        }
    }
}

