/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class GenericContentTypeRelatedExtension<T> {
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    private static final String ENABLED_WHEN_ATTRIBUTE = "enabledWhen";
    public final IConfigurationElement extension;
    public final IContentType targetContentType;
    public final Expression enabledWhen;

    public GenericContentTypeRelatedExtension(IConfigurationElement element) throws Exception {
        this.extension = element;
        this.targetContentType = Platform.getContentTypeManager().getContentType(element.getAttribute(CONTENT_TYPE_ATTRIBUTE));
        this.enabledWhen = GenericContentTypeRelatedExtension.buildEnabledWhen(element);
    }

    public T createDelegate() {
        Object delegateInstance = this.createDelegateWithoutTypeCheck();
        return (T)delegateInstance;
    }

    public <E> E createDelegateWithoutTypeCheck() {
        try {
            return (E)this.extension.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static Expression buildEnabledWhen(IConfigurationElement configElement) throws CoreException {
        IConfigurationElement[] children = configElement.getChildren(ENABLED_WHEN_ATTRIBUTE);
        if (children.length > 0) {
            IConfigurationElement[] subChildren = children[0].getChildren();
            if (subChildren.length != 1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.genericeditor", "One <enabledWhen> element is accepted. Disabling " + configElement.getAttribute(ID_ATTRIBUTE)));
            }
            ElementHandler elementHandler = ElementHandler.getDefault();
            ExpressionConverter converter = ExpressionConverter.getDefault();
            return elementHandler.create(converter, subChildren[0]);
        }
        return null;
    }

    public boolean matches(ISourceViewer viewer, ITextEditor editor) {
        if (this.enabledWhen == null) {
            return true;
        }
        EvaluationContext context = new EvaluationContext(null, editor != null ? editor : viewer);
        context.setAllowPluginActivation(true);
        context.addVariable("viewer", (Object)viewer);
        if (viewer.getDocument() != null) {
            context.addVariable("document", (Object)viewer.getDocument());
        } else {
            context.addVariable("document", IEvaluationContext.UNDEFINED_VARIABLE);
        }
        context.addVariable("editor", editor != null ? editor : IEvaluationContext.UNDEFINED_VARIABLE);
        context.addVariable("editorInput", editor != null ? editor.getEditorInput() : IEvaluationContext.UNDEFINED_VARIABLE);
        try {
            return this.enabledWhen.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", "Error while 'enabledWhen' evaluation", (Throwable)e));
            return false;
        }
    }

    public String getContributionName() {
        return this.extension.getName();
    }
}

