/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.codemining;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractCodeMining
implements ICodeMining {
    private final Position position;
    private final ICodeMiningProvider provider;
    private CompletableFuture<Void> resolveFuture;
    private String label;
    private final Consumer<MouseEvent> action;

    protected AbstractCodeMining(Position position, ICodeMiningProvider provider, Consumer<MouseEvent> action) {
        this.position = position;
        this.provider = provider;
        this.action = action;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public ICodeMiningProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public final CompletableFuture<Void> resolve(ITextViewer viewer, IProgressMonitor monitor) {
        if (this.resolveFuture == null) {
            this.resolveFuture = this.doResolve(viewer, monitor);
        }
        return this.resolveFuture;
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isResolved() {
        return this.resolveFuture != null && this.resolveFuture.isDone();
    }

    @Override
    public void dispose() {
        if (this.resolveFuture != null) {
            this.resolveFuture.cancel(true);
            this.resolveFuture = null;
        }
    }

    @Override
    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        String title = this.getLabel() != null ? this.getLabel() : "no command";
        gc.drawString(title, x, y, true);
        Point result = gc.stringExtent(title);
        result.y += textWidget.getLineSpacing();
        return result;
    }

    @Override
    public Consumer<MouseEvent> getAction() {
        return this.action;
    }
}

