/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.ConnectionsHelper;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkElementHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class NegateConnectionCommand
extends Command
implements ScopedCommand {
    private final Connection connection;
    private final boolean isNegated;
    private final boolean performMappingCheck;
    private NegateConnectionCommand mappedNegateConnCmd;

    public NegateConnectionCommand(Connection connection, boolean isNegated) {
        this(connection, isNegated, true);
    }

    private NegateConnectionCommand(Connection connection, boolean isNegated, boolean performMappingCheck) {
        this.connection = Objects.requireNonNull(connection);
        this.isNegated = isNegated;
        this.performMappingCheck = performMappingCheck;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.connection);
    }

    public boolean canExecute() {
        EObject eObject = this.connection.getFBNetwork().eContainer();
        if (eObject instanceof FBNetworkElement) {
            SubApp subApp;
            FBNetworkElement fbnEl = (FBNetworkElement)eObject;
            if (fbnEl instanceof SubApp && (subApp = (SubApp)fbnEl).isTyped() || fbnEl instanceof CFBInstance) {
                return false;
            }
            return !FBNetworkElementHelper.isContainedInTypedInstance((EObject)fbnEl);
        }
        return true;
    }

    public void execute() {
        this.setNegated(this.isNegated);
        if (this.performMappingCheck) {
            this.mappedNegateConnCmd = this.checkAndNegateMirroredConnection();
            if (this.mappedNegateConnCmd != null) {
                this.mappedNegateConnCmd.execute();
            }
        }
    }

    public void undo() {
        this.setNegated(!this.isNegated);
        if (this.mappedNegateConnCmd != null) {
            this.mappedNegateConnCmd.undo();
        }
    }

    public void redo() {
        this.setNegated(this.isNegated);
        if (this.mappedNegateConnCmd != null) {
            this.mappedNegateConnCmd.redo();
        }
    }

    public void setNegated(boolean negated) {
        this.connection.setNegated(negated);
    }

    private NegateConnectionCommand checkAndNegateMirroredConnection() {
        Connection opposite = ConnectionsHelper.getOppositeConnection((Connection)this.connection);
        if (opposite != null) {
            NegateConnectionCommand cmd = new NegateConnectionCommand(opposite, this.isNegated, false);
            return cmd.canExecute() ? cmd : null;
        }
        return null;
    }
}

