/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.debug.replaydebugging.trace;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fordiac.debug.replaydebugging.trace.SendOutputEvent;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;

public class TracesReader {
    private final File path;
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^trace_(.+)_\\d{8}_\\d{9}\\.ctf$");
    private static final String TYPENAME_FIELD = "typeName";
    private static final String INSTANCENAME_FIELD = "instanceName";
    private static final String EVENTID_FIELD = "eventId";
    private static final String EVENTCOUNTER_FIELD = "eventCounter";
    private static final String OUTPUTS_FIELD = "outputs";
    private static final String SEND_OUTPUT_EVENT = "sendOutputEvent";

    public TracesReader(String path) {
        this.path = new File(path);
    }

    public Map<String, List<SendOutputEvent>> read() throws CTFException {
        HashMap<String, List<SendOutputEvent>> events = new HashMap<String, List<SendOutputEvent>>();
        CTFTrace trace = new CTFTrace(this.path.getAbsolutePath());
        Throwable throwable = null;
        Object var4_5 = null;
        try (CTFTraceReader reader = new CTFTraceReader(trace);){
            while (reader.hasMoreEvents()) {
                IEventDefinition event = reader.getCurrentEventDef();
                String resourceName = TracesReader.getResourceName(reader.getTopStream().getFilename());
                List resourceEvents = events.computeIfAbsent(resourceName, k -> new ArrayList());
                reader.advance();
                String eventType = event.getDeclaration().getName();
                if (!eventType.equals(SEND_OUTPUT_EVENT)) continue;
                ICompositeDefinition fields = event.getFields();
                resourceEvents.add(new SendOutputEvent(((StringDefinition)fields.getDefinition(TYPENAME_FIELD)).getValue(), ((StringDefinition)fields.getDefinition(INSTANCENAME_FIELD)).getValue(), (int)((IntegerDefinition)fields.getDefinition(EVENTID_FIELD)).getValue(), (int)((IntegerDefinition)fields.getDefinition(EVENTCOUNTER_FIELD)).getValue(), ((AbstractArrayDefinition)fields.getDefinition(OUTPUTS_FIELD)).getDefinitions().stream().map(StringDefinition.class::cast).map(StringDefinition::getValue).toList()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return events;
    }

    private static String getResourceName(String fileName) throws CTFException {
        Matcher match = FILENAME_PATTERN.matcher(fileName);
        if (!match.find()) {
            throw new CTFException("Filename does not match expected pattern: " + fileName);
        }
        return match.group(1);
    }
}

